/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="randomkeys", aliases={"rk"}, description={"Generate volumes/buckets and put generated keys."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public final class RandomKeyGenerator
implements Callable<Void> {
    @CommandLine.ParentCommand
    private Freon freon;
    private static final String RATIS = "ratis";
    private static final String DURATION_FORMAT = "HH:mm:ss,SSS";
    private static final int QUANTILES = 10;
    private static final Logger LOG = LoggerFactory.getLogger(RandomKeyGenerator.class);
    private boolean completed = false;
    private boolean exception = false;
    @CommandLine.Option(names={"--numOfThreads"}, description={"number of threads to be launched for the run"}, defaultValue="10")
    private int numOfThreads = 10;
    @CommandLine.Option(names={"--numOfVolumes"}, description={"specifies number of Volumes to be created in offline mode"}, defaultValue="10")
    private int numOfVolumes = 10;
    @CommandLine.Option(names={"--numOfBuckets"}, description={"specifies number of Buckets to be created per Volume"}, defaultValue="1000")
    private int numOfBuckets = 1000;
    @CommandLine.Option(names={"--numOfKeys"}, description={"specifies number of Keys to be created per Bucket"}, defaultValue="500000")
    private int numOfKeys = 500000;
    @CommandLine.Option(names={"--keySize"}, description={"Specifies the size of Key in bytes to be created"}, defaultValue="10240")
    private int keySize = 10240;
    @CommandLine.Option(names={"--json"}, description={"directory where json is created."})
    private String jsonDir;
    @CommandLine.Option(names={"--replicationType"}, description={"Replication type (STAND_ALONE, RATIS)"}, defaultValue="STAND_ALONE")
    private ReplicationType type = ReplicationType.STAND_ALONE;
    @CommandLine.Option(names={"--factor"}, description={"Replication factor (ONE, THREE)"}, defaultValue="ONE")
    private ReplicationFactor factor = ReplicationFactor.ONE;
    private int threadPoolSize;
    private byte[] keyValue = null;
    private boolean validateWrites;
    private OzoneClient ozoneClient;
    private ObjectStore objectStore;
    private ExecutorService processor;
    private long startTime;
    private long jobStartTime;
    private AtomicLong volumeCreationTime;
    private AtomicLong bucketCreationTime;
    private AtomicLong keyCreationTime;
    private AtomicLong keyWriteTime;
    private AtomicLong totalBytesWritten;
    private AtomicInteger numberOfVolumesCreated;
    private AtomicInteger numberOfBucketsCreated;
    private AtomicLong numberOfKeysAdded;
    private Long totalWritesValidated;
    private Long writeValidationSuccessCount;
    private Long writeValidationFailureCount;
    private BlockingQueue<KeyValue> validationQueue;
    private ArrayList<Histogram> histograms = new ArrayList();
    private OzoneConfiguration ozoneConfiguration;

    RandomKeyGenerator() {
    }

    @VisibleForTesting
    RandomKeyGenerator(OzoneConfiguration ozoneConfiguration) {
        this.ozoneConfiguration = ozoneConfiguration;
    }

    public void init(OzoneConfiguration configuration) throws IOException {
        this.startTime = System.nanoTime();
        this.jobStartTime = System.currentTimeMillis();
        this.volumeCreationTime = new AtomicLong();
        this.bucketCreationTime = new AtomicLong();
        this.keyCreationTime = new AtomicLong();
        this.keyWriteTime = new AtomicLong();
        this.totalBytesWritten = new AtomicLong();
        this.numberOfVolumesCreated = new AtomicInteger();
        this.numberOfBucketsCreated = new AtomicInteger();
        this.numberOfKeysAdded = new AtomicLong();
        this.ozoneClient = OzoneClientFactory.getClient((Configuration)configuration);
        this.objectStore = this.ozoneClient.getObjectStore();
        for (FreonOps ops : FreonOps.values()) {
            this.histograms.add(ops.ordinal(), new Histogram((Reservoir)new UniformReservoir()));
        }
    }

    @Override
    public Void call() throws Exception {
        if (this.ozoneConfiguration != null) {
            this.init(this.ozoneConfiguration);
        } else {
            this.init(this.freon.createOzoneConfiguration());
        }
        this.keyValue = DFSUtil.string2Bytes((String)RandomStringUtils.randomAscii((int)(this.keySize - 36)));
        LOG.info("Number of Threads: " + this.numOfThreads);
        this.threadPoolSize = Math.min(this.numOfVolumes, this.numOfThreads);
        this.processor = Executors.newFixedThreadPool(this.threadPoolSize);
        this.addShutdownHook();
        LOG.info("Number of Volumes: {}.", (Object)this.numOfVolumes);
        LOG.info("Number of Buckets per Volume: {}.", (Object)this.numOfBuckets);
        LOG.info("Number of Keys per Bucket: {}.", (Object)this.numOfKeys);
        LOG.info("Key size: {} bytes", (Object)this.keySize);
        for (int i = 0; i < this.numOfVolumes; ++i) {
            String volume = "vol-" + i + "-" + RandomStringUtils.randomNumeric((int)5);
            this.processor.submit(new OfflineProcessor(volume));
        }
        Thread validator = null;
        if (this.validateWrites) {
            this.totalWritesValidated = 0L;
            this.writeValidationSuccessCount = 0L;
            this.writeValidationFailureCount = 0L;
            this.validationQueue = new ArrayBlockingQueue<KeyValue>(this.numOfThreads);
            validator = new Thread(new Validator());
            validator.start();
            LOG.info("Data validation is enabled.");
        }
        Thread progressbar = this.getProgressBarThread();
        LOG.info("Starting progress bar Thread.");
        progressbar.start();
        this.processor.shutdown();
        this.processor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        this.completed = true;
        progressbar.join();
        if (this.validateWrites) {
            validator.join();
        }
        this.ozoneClient.close();
        return null;
    }

    private void parseOptions(CommandLine cmdLine) {
        if (this.keySize < 1024) {
            throw new IllegalArgumentException("keySize can not be less than 1024 bytes");
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.printStats(System.out)));
    }

    private Thread getProgressBarThread() {
        Supplier<Long> currentValue = () -> this.numberOfKeysAdded.get();
        long maxValue = this.numOfVolumes * this.numOfBuckets * this.numOfKeys;
        Thread progressBarThread = new Thread(new ProgressBar(System.out, currentValue, maxValue));
        progressBarThread.setName("ProgressBar");
        return progressBarThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStats(PrintStream out) {
        long endTime = System.nanoTime() - this.startTime;
        String execTime = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis(endTime), (String)DURATION_FORMAT);
        long volumeTime = TimeUnit.NANOSECONDS.toMillis(this.volumeCreationTime.get()) / (long)this.threadPoolSize;
        String prettyAverageVolumeTime = DurationFormatUtils.formatDuration((long)volumeTime, (String)DURATION_FORMAT);
        long bucketTime = TimeUnit.NANOSECONDS.toMillis(this.bucketCreationTime.get()) / (long)this.threadPoolSize;
        String prettyAverageBucketTime = DurationFormatUtils.formatDuration((long)bucketTime, (String)DURATION_FORMAT);
        long averageKeyCreationTime = TimeUnit.NANOSECONDS.toMillis(this.keyCreationTime.get()) / (long)this.threadPoolSize;
        String prettyAverageKeyCreationTime = DurationFormatUtils.formatDuration((long)averageKeyCreationTime, (String)DURATION_FORMAT);
        long averageKeyWriteTime = TimeUnit.NANOSECONDS.toMillis(this.keyWriteTime.get()) / (long)this.threadPoolSize;
        String prettyAverageKeyWriteTime = DurationFormatUtils.formatDuration((long)averageKeyWriteTime, (String)DURATION_FORMAT);
        out.println();
        out.println("***************************************************");
        out.println("Status: " + (this.exception ? "Failed" : "Success"));
        out.println("Git Base Revision: " + VersionInfo.getRevision());
        out.println("Number of Volumes created: " + this.numberOfVolumesCreated);
        out.println("Number of Buckets created: " + this.numberOfBucketsCreated);
        out.println("Number of Keys added: " + this.numberOfKeysAdded);
        out.println("Ratis replication factor: " + this.factor.name());
        out.println("Ratis replication type: " + this.type.name());
        out.println("Average Time spent in volume creation: " + prettyAverageVolumeTime);
        out.println("Average Time spent in bucket creation: " + prettyAverageBucketTime);
        out.println("Average Time spent in key creation: " + prettyAverageKeyCreationTime);
        out.println("Average Time spent in key write: " + prettyAverageKeyWriteTime);
        out.println("Total bytes written: " + this.totalBytesWritten);
        if (this.validateWrites) {
            out.println("Total number of writes validated: " + this.totalWritesValidated);
            out.println("Writes validated: " + 100.0 * (double)this.totalWritesValidated.longValue() / (double)this.numberOfKeysAdded.get() + " %");
            out.println("Successful validation: " + this.writeValidationSuccessCount);
            out.println("Unsuccessful validation: " + this.writeValidationFailureCount);
        }
        out.println("Total Execution time: " + execTime);
        out.println("***************************************************");
        if (this.jsonDir != null) {
            String[][] quantileTime = new String[FreonOps.values().length][11];
            String[] deviations = new String[FreonOps.values().length];
            String[] means = new String[FreonOps.values().length];
            for (FreonOps ops : FreonOps.values()) {
                Snapshot snapshot = this.histograms.get(ops.ordinal()).getSnapshot();
                for (int i = 0; i <= 10; ++i) {
                    quantileTime[ops.ordinal()][i] = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)snapshot.getValue(0.1 * (double)i)), (String)DURATION_FORMAT);
                }
                deviations[ops.ordinal()] = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)snapshot.getStdDev()), (String)DURATION_FORMAT);
                means[ops.ordinal()] = DurationFormatUtils.formatDuration((long)TimeUnit.NANOSECONDS.toMillis((long)snapshot.getMean()), (String)DURATION_FORMAT);
            }
            FreonJobInfo jobInfo = new FreonJobInfo().setExecTime(execTime).setGitBaseRevision(VersionInfo.getRevision()).setMeanVolumeCreateTime(means[FreonOps.VOLUME_CREATE.ordinal()]).setDeviationVolumeCreateTime(deviations[FreonOps.VOLUME_CREATE.ordinal()]).setTenQuantileVolumeCreateTime(quantileTime[FreonOps.VOLUME_CREATE.ordinal()]).setMeanBucketCreateTime(means[FreonOps.BUCKET_CREATE.ordinal()]).setDeviationBucketCreateTime(deviations[FreonOps.BUCKET_CREATE.ordinal()]).setTenQuantileBucketCreateTime(quantileTime[FreonOps.BUCKET_CREATE.ordinal()]).setMeanKeyCreateTime(means[FreonOps.KEY_CREATE.ordinal()]).setDeviationKeyCreateTime(deviations[FreonOps.KEY_CREATE.ordinal()]).setTenQuantileKeyCreateTime(quantileTime[FreonOps.KEY_CREATE.ordinal()]).setMeanKeyWriteTime(means[FreonOps.KEY_WRITE.ordinal()]).setDeviationKeyWriteTime(deviations[FreonOps.KEY_WRITE.ordinal()]).setTenQuantileKeyWriteTime(quantileTime[FreonOps.KEY_WRITE.ordinal()]);
            String jsonName = new SimpleDateFormat("yyyyMMddHHmmss").format(Time.now()) + ".json";
            String jsonPath = this.jsonDir + "/" + jsonName;
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(jsonPath);
                ObjectMapper mapper = new ObjectMapper();
                mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
                writer.writeValue((OutputStream)os, (Object)jobInfo);
            }
            catch (FileNotFoundException e) {
                out.println("Json File could not be created for the path: " + jsonPath);
                out.println(e);
            }
            catch (IOException e) {
                out.println("Json object could not be created");
                out.println(e);
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Could not close the output stream for json", (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    int getNumberOfVolumesCreated() {
        return this.numberOfVolumesCreated.get();
    }

    @VisibleForTesting
    int getNumberOfBucketsCreated() {
        return this.numberOfBucketsCreated.get();
    }

    @VisibleForTesting
    long getNumberOfKeysAdded() {
        return this.numberOfKeysAdded.get();
    }

    @VisibleForTesting
    boolean getValidateWrites() {
        return this.validateWrites;
    }

    @VisibleForTesting
    long getTotalKeysValidated() {
        return this.totalWritesValidated;
    }

    @VisibleForTesting
    long getSuccessfulValidationCount() {
        return this.writeValidationSuccessCount;
    }

    @VisibleForTesting
    long getUnsuccessfulValidationCount() {
        return this.writeValidationFailureCount;
    }

    @VisibleForTesting
    long getKeyValueLength() {
        return this.keyValue.length;
    }

    @VisibleForTesting
    public void setNumOfVolumes(int numOfVolumes) {
        this.numOfVolumes = numOfVolumes;
    }

    @VisibleForTesting
    public void setNumOfBuckets(int numOfBuckets) {
        this.numOfBuckets = numOfBuckets;
    }

    @VisibleForTesting
    public void setNumOfKeys(int numOfKeys) {
        this.numOfKeys = numOfKeys;
    }

    @VisibleForTesting
    public void setNumOfThreads(int numOfThreads) {
        this.numOfThreads = numOfThreads;
    }

    @VisibleForTesting
    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @VisibleForTesting
    public void setType(ReplicationType type) {
        this.type = type;
    }

    @VisibleForTesting
    public void setFactor(ReplicationFactor factor) {
        this.factor = factor;
    }

    @VisibleForTesting
    public void setValidateWrites(boolean validateWrites) {
        this.validateWrites = validateWrites;
    }

    private class Validator
    implements Runnable {
        private Validator() {
        }

        @Override
        public void run() {
            while (!RandomKeyGenerator.this.completed) {
                try {
                    KeyValue kv = (KeyValue)RandomKeyGenerator.this.validationQueue.poll(5L, TimeUnit.SECONDS);
                    if (kv == null) continue;
                    OzoneInputStream is = kv.bucket.readKey(kv.key);
                    byte[] value = new byte[kv.value.length];
                    int length = is.read(value);
                    Long l = RandomKeyGenerator.this.totalWritesValidated;
                    Long l2 = RandomKeyGenerator.this.totalWritesValidated = RandomKeyGenerator.this.totalWritesValidated + 1L;
                    if (length == kv.value.length && Arrays.equals(value, kv.value)) {
                        l = RandomKeyGenerator.this.writeValidationSuccessCount;
                        l2 = RandomKeyGenerator.this.writeValidationSuccessCount = RandomKeyGenerator.this.writeValidationSuccessCount + 1L;
                        continue;
                    }
                    l = RandomKeyGenerator.this.writeValidationFailureCount;
                    l2 = RandomKeyGenerator.this.writeValidationFailureCount = RandomKeyGenerator.this.writeValidationFailureCount + 1L;
                    LOG.warn("Data validation error for key {}/{}/{}", new Object[]{kv.bucket.getVolumeName(), kv.bucket, kv.key});
                    LOG.warn("Expected checksum: {}, Actual checksum: {}", (Object)DigestUtils.md5Hex((byte[])kv.value), (Object)DigestUtils.md5Hex((byte[])value));
                }
                catch (IOException | InterruptedException ex) {
                    LOG.error("Exception while validating write: " + ex.getMessage());
                }
            }
        }
    }

    private class ProgressBar
    implements Runnable {
        private static final long REFRESH_INTERVAL = 1000L;
        private PrintStream stream;
        private Supplier<Long> currentValue;
        private long maxValue;

        ProgressBar(PrintStream stream, Supplier<Long> currentValue, long maxValue) {
            this.stream = stream;
            this.currentValue = currentValue;
            this.maxValue = maxValue;
        }

        @Override
        public void run() {
            try {
                long value;
                this.stream.println();
                while ((value = this.currentValue.get().longValue()) < this.maxValue) {
                    this.print(value);
                    if (RandomKeyGenerator.this.completed) break;
                    Thread.sleep(1000L);
                }
                if (RandomKeyGenerator.this.exception) {
                    this.stream.println();
                    this.stream.println("Incomplete termination, check log for exception.");
                } else {
                    this.print(this.maxValue);
                }
                this.stream.println();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void print(long value) {
            this.stream.print('\r');
            double percent = 100.0 * (double)value / (double)this.maxValue;
            StringBuilder sb = new StringBuilder();
            sb.append(" " + String.format("%.2f", percent) + "% |");
            int i = 0;
            while ((double)i <= percent) {
                sb.append('\u2588');
                ++i;
            }
            int j = 0;
            while ((double)j < 100.0 - percent) {
                sb.append(' ');
                ++j;
            }
            sb.append("|  ");
            sb.append(value + "/" + this.maxValue);
            long timeInSec = TimeUnit.SECONDS.convert(System.nanoTime() - RandomKeyGenerator.this.startTime, TimeUnit.NANOSECONDS);
            String timeToPrint = String.format("%d:%02d:%02d", timeInSec / 3600L, timeInSec % 3600L / 60L, timeInSec % 60L);
            sb.append(" Time: " + timeToPrint);
            this.stream.print(sb);
        }
    }

    private final class FreonJobInfo {
        private String status;
        private String gitBaseRevision;
        private String jobStartTime;
        private int numOfVolumes;
        private int numOfBuckets;
        private int numOfKeys;
        private int numOfThreads;
        private String dataWritten;
        private String execTime;
        private String replicationFactor;
        private String replicationType;
        private int keySize;
        private String totalThroughputPerSecond;
        private String meanVolumeCreateTime;
        private String deviationVolumeCreateTime;
        private String[] tenQuantileVolumeCreateTime;
        private String meanBucketCreateTime;
        private String deviationBucketCreateTime;
        private String[] tenQuantileBucketCreateTime;
        private String meanKeyCreateTime;
        private String deviationKeyCreateTime;
        private String[] tenQuantileKeyCreateTime;
        private String meanKeyWriteTime;
        private String deviationKeyWriteTime;
        private String[] tenQuantileKeyWriteTime;

        private FreonJobInfo() {
            this.status = RandomKeyGenerator.this.exception ? "Failed" : "Success";
            this.numOfVolumes = RandomKeyGenerator.this.numOfVolumes;
            this.numOfBuckets = RandomKeyGenerator.this.numOfBuckets;
            this.numOfKeys = RandomKeyGenerator.this.numOfKeys;
            this.numOfThreads = RandomKeyGenerator.this.numOfThreads;
            this.keySize = RandomKeyGenerator.this.keySize;
            this.jobStartTime = Time.formatTime((long)RandomKeyGenerator.this.jobStartTime);
            this.replicationFactor = RandomKeyGenerator.this.factor.name();
            this.replicationType = RandomKeyGenerator.this.type.name();
            long totalBytes = (long)this.numOfVolumes * (long)this.numOfBuckets * (long)this.numOfKeys * (long)this.keySize;
            this.dataWritten = this.getInStorageUnits(Double.valueOf(totalBytes));
            this.totalThroughputPerSecond = this.getInStorageUnits((double)totalBytes * 1.0 / (double)TimeUnit.NANOSECONDS.toSeconds(RandomKeyGenerator.this.keyWriteTime.get() / (long)RandomKeyGenerator.this.threadPoolSize));
        }

        private String getInStorageUnits(Double value) {
            OzoneQuota.Units unit;
            double size;
            if ((long)(value / 1.099511627776E12) != 0L) {
                size = value / 1.099511627776E12;
                unit = OzoneQuota.Units.TB;
            } else if ((long)(value / 1.073741824E9) != 0L) {
                size = value / 1.073741824E9;
                unit = OzoneQuota.Units.GB;
            } else if ((long)(value / 1048576.0) != 0L) {
                size = value / 1048576.0;
                unit = OzoneQuota.Units.MB;
            } else if ((long)(value / 1024.0) != 0L) {
                size = value / 1024.0;
                unit = OzoneQuota.Units.KB;
            } else {
                size = value;
                unit = OzoneQuota.Units.BYTES;
            }
            return size + " " + unit;
        }

        public FreonJobInfo setGitBaseRevision(String gitBaseRevisionVal) {
            this.gitBaseRevision = gitBaseRevisionVal;
            return this;
        }

        public FreonJobInfo setExecTime(String execTimeVal) {
            this.execTime = execTimeVal;
            return this;
        }

        public FreonJobInfo setMeanKeyWriteTime(String deviationKeyWriteTimeVal) {
            this.meanKeyWriteTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationKeyWriteTime(String deviationKeyWriteTimeVal) {
            this.deviationKeyWriteTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileKeyWriteTime(String[] tenQuantileKeyWriteTimeVal) {
            this.tenQuantileKeyWriteTime = tenQuantileKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setMeanKeyCreateTime(String deviationKeyWriteTimeVal) {
            this.meanKeyCreateTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationKeyCreateTime(String deviationKeyCreateTimeVal) {
            this.deviationKeyCreateTime = deviationKeyCreateTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileKeyCreateTime(String[] tenQuantileKeyCreateTimeVal) {
            this.tenQuantileKeyCreateTime = tenQuantileKeyCreateTimeVal;
            return this;
        }

        public FreonJobInfo setMeanBucketCreateTime(String deviationKeyWriteTimeVal) {
            this.meanBucketCreateTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationBucketCreateTime(String deviationBucketCreateTimeVal) {
            this.deviationBucketCreateTime = deviationBucketCreateTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileBucketCreateTime(String[] tenQuantileBucketCreateTimeVal) {
            this.tenQuantileBucketCreateTime = tenQuantileBucketCreateTimeVal;
            return this;
        }

        public FreonJobInfo setMeanVolumeCreateTime(String deviationKeyWriteTimeVal) {
            this.meanVolumeCreateTime = deviationKeyWriteTimeVal;
            return this;
        }

        public FreonJobInfo setDeviationVolumeCreateTime(String deviationVolumeCreateTimeVal) {
            this.deviationVolumeCreateTime = deviationVolumeCreateTimeVal;
            return this;
        }

        public FreonJobInfo setTenQuantileVolumeCreateTime(String[] tenQuantileVolumeCreateTimeVal) {
            this.tenQuantileVolumeCreateTime = tenQuantileVolumeCreateTimeVal;
            return this;
        }

        public String getJobStartTime() {
            return this.jobStartTime;
        }

        public int getNumOfVolumes() {
            return this.numOfVolumes;
        }

        public int getNumOfBuckets() {
            return this.numOfBuckets;
        }

        public int getNumOfKeys() {
            return this.numOfKeys;
        }

        public int getNumOfThreads() {
            return this.numOfThreads;
        }

        public String getExecTime() {
            return this.execTime;
        }

        public String getReplicationFactor() {
            return this.replicationFactor;
        }

        public String getReplicationType() {
            return this.replicationType;
        }

        public String getStatus() {
            return this.status;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public String getGitBaseRevision() {
            return this.gitBaseRevision;
        }

        public String getDataWritten() {
            return this.dataWritten;
        }

        public String getTotalThroughputPerSecond() {
            return this.totalThroughputPerSecond;
        }

        public String getMeanVolumeCreateTime() {
            return this.meanVolumeCreateTime;
        }

        public String getDeviationVolumeCreateTime() {
            return this.deviationVolumeCreateTime;
        }

        public String[] getTenQuantileVolumeCreateTime() {
            return this.tenQuantileVolumeCreateTime;
        }

        public String getMeanBucketCreateTime() {
            return this.meanBucketCreateTime;
        }

        public String getDeviationBucketCreateTime() {
            return this.deviationBucketCreateTime;
        }

        public String[] getTenQuantileBucketCreateTime() {
            return this.tenQuantileBucketCreateTime;
        }

        public String getMeanKeyCreateTime() {
            return this.meanKeyCreateTime;
        }

        public String getDeviationKeyCreateTime() {
            return this.deviationKeyCreateTime;
        }

        public String[] getTenQuantileKeyCreateTime() {
            return this.tenQuantileKeyCreateTime;
        }

        public String getMeanKeyWriteTime() {
            return this.meanKeyWriteTime;
        }

        public String getDeviationKeyWriteTime() {
            return this.deviationKeyWriteTime;
        }

        public String[] getTenQuantileKeyWriteTime() {
            return this.tenQuantileKeyWriteTime;
        }
    }

    private class OfflineProcessor
    implements Runnable {
        private int totalBuckets;
        private int totalKeys;
        private String volumeName;

        OfflineProcessor(String volumeName) {
            this.totalBuckets = RandomKeyGenerator.this.numOfBuckets;
            this.totalKeys = RandomKeyGenerator.this.numOfKeys;
            this.volumeName = volumeName;
        }

        @Override
        public void run() {
            OzoneVolume volume;
            LOG.trace("Creating volume: {}", (Object)this.volumeName);
            long start = System.nanoTime();
            try {
                RandomKeyGenerator.this.objectStore.createVolume(this.volumeName);
                long volumeCreationDuration = System.nanoTime() - start;
                RandomKeyGenerator.this.volumeCreationTime.getAndAdd(volumeCreationDuration);
                ((Histogram)RandomKeyGenerator.this.histograms.get(FreonOps.VOLUME_CREATE.ordinal())).update(volumeCreationDuration);
                RandomKeyGenerator.this.numberOfVolumesCreated.getAndIncrement();
                volume = RandomKeyGenerator.this.objectStore.getVolume(this.volumeName);
            }
            catch (IOException e) {
                RandomKeyGenerator.this.exception = true;
                LOG.error("Could not create volume", (Throwable)e);
                return;
            }
            Long threadKeyWriteTime = 0L;
            for (int j = 0; j < this.totalBuckets; ++j) {
                String bucketName = "bucket-" + j + "-" + RandomStringUtils.randomNumeric((int)5);
                try {
                    LOG.trace("Creating bucket: {} in volume: {}", (Object)bucketName, (Object)volume.getName());
                    start = System.nanoTime();
                    volume.createBucket(bucketName);
                    long bucketCreationDuration = System.nanoTime() - start;
                    ((Histogram)RandomKeyGenerator.this.histograms.get(FreonOps.BUCKET_CREATE.ordinal())).update(bucketCreationDuration);
                    RandomKeyGenerator.this.bucketCreationTime.getAndAdd(bucketCreationDuration);
                    RandomKeyGenerator.this.numberOfBucketsCreated.getAndIncrement();
                    OzoneBucket bucket = volume.getBucket(bucketName);
                    for (int k = 0; k < this.totalKeys; ++k) {
                        String key = "key-" + k + "-" + RandomStringUtils.randomNumeric((int)5);
                        byte[] randomValue = DFSUtil.string2Bytes((String)UUID.randomUUID().toString());
                        try {
                            LOG.trace("Adding key: {} in bucket: {} of volume: {}", new Object[]{key, bucket, volume});
                            long keyCreateStart = System.nanoTime();
                            OzoneOutputStream os = bucket.createKey(key, (long)RandomKeyGenerator.this.keySize, RandomKeyGenerator.this.type, RandomKeyGenerator.this.factor);
                            long keyCreationDuration = System.nanoTime() - keyCreateStart;
                            ((Histogram)RandomKeyGenerator.this.histograms.get(FreonOps.KEY_CREATE.ordinal())).update(keyCreationDuration);
                            RandomKeyGenerator.this.keyCreationTime.getAndAdd(keyCreationDuration);
                            long keyWriteStart = System.nanoTime();
                            os.write(RandomKeyGenerator.this.keyValue);
                            os.write(randomValue);
                            os.close();
                            long keyWriteDuration = System.nanoTime() - keyWriteStart;
                            threadKeyWriteTime = threadKeyWriteTime + keyWriteDuration;
                            ((Histogram)RandomKeyGenerator.this.histograms.get(FreonOps.KEY_WRITE.ordinal())).update(keyWriteDuration);
                            RandomKeyGenerator.this.totalBytesWritten.getAndAdd(RandomKeyGenerator.this.keySize);
                            RandomKeyGenerator.this.numberOfKeysAdded.getAndIncrement();
                            if (!RandomKeyGenerator.this.validateWrites) continue;
                            byte[] value = ArrayUtils.addAll((byte[])RandomKeyGenerator.this.keyValue, (byte[])randomValue);
                            boolean validate = RandomKeyGenerator.this.validationQueue.offer(new KeyValue(bucket, key, value));
                            if (!validate) continue;
                            LOG.trace("Key {}, is queued for validation.", (Object)key);
                            continue;
                        }
                        catch (Exception e) {
                            RandomKeyGenerator.this.exception = true;
                            LOG.error("Exception while adding key: {} in bucket: {} of volume: {}.", new Object[]{key, bucket, volume, e});
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    RandomKeyGenerator.this.exception = true;
                    LOG.error("Exception while creating bucket: {} in volume: {}.", new Object[]{bucketName, volume, e});
                }
            }
            RandomKeyGenerator.this.keyWriteTime.getAndAdd(threadKeyWriteTime);
        }
    }

    private static class KeyValue {
        private OzoneBucket bucket;
        private String key;
        private byte[] value;

        KeyValue(OzoneBucket bucket, String key, byte[] value) {
            this.bucket = bucket;
            this.key = key;
            this.value = value;
        }
    }

    static enum FreonOps {
        VOLUME_CREATE,
        BUCKET_CREATE,
        KEY_CREATE,
        KEY_WRITE;

    }
}

