/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.io.opencensus.tags;

import javax.annotation.concurrent.Immutable;
import org.apache.ratis.shaded.com.google.common.base.Preconditions;
import org.apache.ratis.shaded.io.opencensus.internal.StringUtil;
import org.apache.ratis.shaded.io.opencensus.tags.AutoValue_TagKey;

@Immutable
public abstract class TagKey {
    public static final int MAX_LENGTH = 255;

    TagKey() {
    }

    public static TagKey create(String name) {
        Preconditions.checkArgument(TagKey.isValid(name));
        return new AutoValue_TagKey(name);
    }

    public abstract String getName();

    private static boolean isValid(String name) {
        return !name.isEmpty() && name.length() <= 255 && StringUtil.isPrintableString(name);
    }
}

