/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.io.grpc.stub;

import com.google.errorprone.annotations.DoNotMock;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.ratis.shaded.com.google.common.base.Preconditions;
import org.apache.ratis.shaded.io.grpc.CallCredentials;
import org.apache.ratis.shaded.io.grpc.CallOptions;
import org.apache.ratis.shaded.io.grpc.Channel;
import org.apache.ratis.shaded.io.grpc.ClientInterceptor;
import org.apache.ratis.shaded.io.grpc.ClientInterceptors;
import org.apache.ratis.shaded.io.grpc.Deadline;
import org.apache.ratis.shaded.io.grpc.ExperimentalApi;

@DoNotMock
@CheckReturnValue
@ThreadSafe
public abstract class AbstractStub<S extends AbstractStub<S>> {
    private final Channel channel;
    private final CallOptions callOptions;

    protected AbstractStub(Channel channel) {
        this(channel, CallOptions.DEFAULT);
    }

    protected AbstractStub(Channel channel, CallOptions callOptions) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final CallOptions getCallOptions() {
        return this.callOptions;
    }

    protected abstract S build(Channel var1, CallOptions var2);

    public final S withDeadline(@Nullable Deadline deadline) {
        return this.build(this.channel, this.callOptions.withDeadline(deadline));
    }

    public final S withDeadlineAfter(long duration, TimeUnit unit) {
        return this.build(this.channel, this.callOptions.withDeadlineAfter(duration, unit));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3605")
    public final S withExecutor(Executor executor) {
        return this.build(this.channel, this.callOptions.withExecutor(executor));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public final S withCompression(String compressorName) {
        return this.build(this.channel, this.callOptions.withCompression(compressorName));
    }

    @Deprecated
    public final S withChannel(Channel newChannel) {
        return this.build(newChannel, this.callOptions);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1869")
    public final <T> S withOption(CallOptions.Key<T> key, T value) {
        return this.build(this.channel, this.callOptions.withOption(key, value));
    }

    public final S withInterceptors(ClientInterceptor ... interceptors) {
        return this.build(ClientInterceptors.intercept(this.channel, interceptors), this.callOptions);
    }

    public final S withCallCredentials(CallCredentials credentials) {
        return this.build(this.channel, this.callOptions.withCallCredentials(credentials));
    }

    public final S withWaitForReady() {
        return this.build(this.channel, this.callOptions.withWaitForReady());
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public final S withMaxInboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxInboundMessageSize(maxSize));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public final S withMaxOutboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxOutboundMessageSize(maxSize));
    }
}

