/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.io.grpc.netty;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ratis.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.shaded.com.google.common.base.MoreObjects;
import org.apache.ratis.shaded.com.google.common.base.Preconditions;
import org.apache.ratis.shaded.com.google.common.collect.ImmutableList;
import org.apache.ratis.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.ratis.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.ratis.shaded.io.grpc.ServerStreamTracer;
import org.apache.ratis.shaded.io.grpc.Status;
import org.apache.ratis.shaded.io.grpc.internal.Channelz;
import org.apache.ratis.shaded.io.grpc.internal.LogId;
import org.apache.ratis.shaded.io.grpc.internal.ServerTransport;
import org.apache.ratis.shaded.io.grpc.internal.ServerTransportListener;
import org.apache.ratis.shaded.io.grpc.internal.TransportTracer;
import org.apache.ratis.shaded.io.grpc.netty.ForcefulCloseCommand;
import org.apache.ratis.shaded.io.grpc.netty.NettyHandlerSettings;
import org.apache.ratis.shaded.io.grpc.netty.NettyServerHandler;
import org.apache.ratis.shaded.io.grpc.netty.ProtocolNegotiator;
import org.apache.ratis.shaded.io.grpc.netty.Utils;
import org.apache.ratis.shaded.io.netty.channel.Channel;
import org.apache.ratis.shaded.io.netty.channel.ChannelFuture;
import org.apache.ratis.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.ratis.shaded.io.netty.channel.ChannelPromise;
import org.apache.ratis.shaded.io.netty.util.concurrent.Future;
import org.apache.ratis.shaded.io.netty.util.concurrent.GenericFutureListener;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private static final Logger connectionLog = Logger.getLogger(String.format("%s.connections", NettyServerTransport.class.getName()));
    private static final ImmutableList<String> QUIET_ERRORS = ImmutableList.of("Connection reset by peer", "An existing connection was forcibly closed by the remote host");
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final Channel channel;
    private final ChannelPromise channelUnused;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreams;
    private NettyServerHandler grpcHandler;
    private ServerTransportListener listener;
    private boolean terminated;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionIdleInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final boolean permitKeepAliveWithoutCalls;
    private final long permitKeepAliveTimeInNanos;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private final TransportTracer transportTracer;

    NettyServerTransport(Channel channel, ChannelPromise channelUnused, ProtocolNegotiator protocolNegotiator, List<ServerStreamTracer.Factory> streamTracerFactories, TransportTracer transportTracer, int maxStreams, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionIdleInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.channelUnused = channelUnused;
        this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
        this.streamTracerFactories = Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories");
        this.transportTracer = Preconditions.checkNotNull(transportTracer, "transportTracer");
        this.maxStreams = maxStreams;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeInNanos = keepAliveTimeInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.maxConnectionIdleInNanos = maxConnectionIdleInNanos;
        this.maxConnectionAgeInNanos = maxConnectionAgeInNanos;
        this.maxConnectionAgeGraceInNanos = maxConnectionAgeGraceInNanos;
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        this.permitKeepAliveTimeInNanos = permitKeepAliveTimeInNanos;
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState(this.listener == null, "Handler already registered");
        this.listener = listener;
        this.grpcHandler = this.createHandler(listener, this.channelUnused);
        NettyHandlerSettings.setAutoWindow(this.grpcHandler);
        final class TerminationNotifier
        implements ChannelFutureListener {
            boolean done;

            TerminationNotifier() {
            }

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!this.done) {
                    this.done = true;
                    NettyServerTransport.this.notifyTerminated(NettyServerTransport.this.grpcHandler.connectionError());
                }
            }
        }
        TerminationNotifier terminationNotifier = new TerminationNotifier();
        this.channelUnused.addListener(terminationNotifier);
        this.channel.closeFuture().addListener(terminationNotifier);
        ProtocolNegotiator.Handler negotiationHandler = this.protocolNegotiator.newHandler(this.grpcHandler);
        this.channel.pipeline().addLast(negotiationHandler);
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.channel.eventLoop();
    }

    @Override
    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    @Override
    public void shutdownNow(Status reason) {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush(new ForcefulCloseCommand(reason));
        }
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    Channel channel() {
        return this.channel;
    }

    @VisibleForTesting
    static Level getLogLevel(Throwable t) {
        if (t instanceof IOException && t.getMessage() != null) {
            for (String msg : QUIET_ERRORS) {
                if (!t.getMessage().equals(msg)) continue;
                return Level.FINE;
            }
        }
        return Level.INFO;
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            connectionLog.log(NettyServerTransport.getLogLevel(t), "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    @Override
    public ListenableFuture<Channelz.SocketStats> getStats() {
        final SettableFuture<Channelz.SocketStats> result = SettableFuture.create();
        if (this.channel.eventLoop().inEventLoop()) {
            result.set(this.getStatsHelper(this.channel));
            return result;
        }
        this.channel.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                result.set(NettyServerTransport.this.getStatsHelper(NettyServerTransport.this.channel));
            }
        }).addListener(new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setException(future.cause());
                }
            }
        });
        return result;
    }

    private Channelz.SocketStats getStatsHelper(Channel ch) {
        Preconditions.checkState(ch.eventLoop().inEventLoop());
        return new Channelz.SocketStats(this.transportTracer.getStats(), this.channel.localAddress(), this.channel.remoteAddress(), Utils.getSocketOptions(ch), this.grpcHandler == null ? null : this.grpcHandler.getSecurityInfo());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logId", this.logId.getId()).add("channel", this.channel).toString();
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener, ChannelPromise channelUnused) {
        return NettyServerHandler.newHandler(transportListener, channelUnused, this.streamTracerFactories, this.transportTracer, this.maxStreams, this.flowControlWindow, this.maxHeaderListSize, this.maxMessageSize, this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, this.maxConnectionIdleInNanos, this.maxConnectionAgeInNanos, this.maxConnectionAgeGraceInNanos, this.permitKeepAliveWithoutCalls, this.permitKeepAliveTimeInNanos);
    }
}

