/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.io.grpc.internal;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.ratis.shaded.io.grpc.Attributes;
import org.apache.ratis.shaded.io.grpc.NameResolver;
import org.apache.ratis.shaded.io.grpc.internal.ForwardingNameResolver;

final class OverrideAuthorityNameResolverFactory
extends NameResolver.Factory {
    private final NameResolver.Factory delegate;
    private final String authorityOverride;

    OverrideAuthorityNameResolverFactory(NameResolver.Factory delegate, String authorityOverride) {
        this.delegate = delegate;
        this.authorityOverride = authorityOverride;
    }

    @Override
    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        NameResolver resolver = this.delegate.newNameResolver(targetUri, params);
        if (resolver == null) {
            return null;
        }
        return new ForwardingNameResolver(resolver){

            @Override
            public String getServiceAuthority() {
                return OverrideAuthorityNameResolverFactory.this.authorityOverride;
            }
        };
    }

    @Override
    public String getDefaultScheme() {
        return this.delegate.getDefaultScheme();
    }
}

