/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.io.grpc;

import java.nio.charset.Charset;
import org.apache.ratis.shaded.io.grpc.Internal;
import org.apache.ratis.shaded.io.grpc.Metadata;

@Internal
public final class InternalMetadata {
    @Internal
    public static final Charset US_ASCII = Charset.forName("US-ASCII");

    @Internal
    public static <T> Metadata.Key<T> keyOf(String name, TrustedAsciiMarshaller<T> marshaller) {
        boolean isPseudo = name != null && !name.isEmpty() && name.charAt(0) == ':';
        return Metadata.Key.of(name, isPseudo, marshaller);
    }

    @Internal
    public static <T> Metadata.Key<T> keyOf(String name, Metadata.AsciiMarshaller<T> marshaller) {
        boolean isPseudo = name != null && !name.isEmpty() && name.charAt(0) == ':';
        return Metadata.Key.of(name, isPseudo, marshaller);
    }

    @Internal
    public static Metadata newMetadata(byte[] ... binaryValues) {
        return new Metadata(binaryValues);
    }

    @Internal
    public static Metadata newMetadata(int usedNames, byte[] ... binaryValues) {
        return new Metadata(usedNames, binaryValues);
    }

    @Internal
    public static byte[][] serialize(Metadata md) {
        return md.serialize();
    }

    @Internal
    public static int headerCount(Metadata md) {
        return md.headerCount();
    }

    @Internal
    public static interface TrustedAsciiMarshaller<T>
    extends Metadata.TrustedAsciiMarshaller<T> {
    }
}

