/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.com.google.protobuf.nano;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.apache.ratis.shaded.com.google.protobuf.nano.CodedInputByteBufferNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.CodedOutputByteBufferNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.ExtendableMessageNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.MapFactories;
import org.apache.ratis.shaded.com.google.protobuf.nano.MessageNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.WireFormatNano;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalNano {
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT64 = 3;
    public static final int TYPE_UINT64 = 4;
    public static final int TYPE_INT32 = 5;
    public static final int TYPE_FIXED64 = 6;
    public static final int TYPE_FIXED32 = 7;
    public static final int TYPE_BOOL = 8;
    public static final int TYPE_STRING = 9;
    public static final int TYPE_GROUP = 10;
    public static final int TYPE_MESSAGE = 11;
    public static final int TYPE_BYTES = 12;
    public static final int TYPE_UINT32 = 13;
    public static final int TYPE_ENUM = 14;
    public static final int TYPE_SFIXED32 = 15;
    public static final int TYPE_SFIXED64 = 16;
    public static final int TYPE_SINT32 = 17;
    public static final int TYPE_SINT64 = 18;
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Object LAZY_INIT_LOCK = new Object();

    private InternalNano() {
    }

    public static String stringDefaultValue(String bytes) {
        return new String(bytes.getBytes(ISO_8859_1), UTF_8);
    }

    public static byte[] bytesDefaultValue(String bytes) {
        return bytes.getBytes(ISO_8859_1);
    }

    public static byte[] copyFromUtf8(String text) {
        return text.getBytes(UTF_8);
    }

    public static boolean equals(int[] field1, int[] field2) {
        if (field1 == null || field1.length == 0) {
            return field2 == null || field2.length == 0;
        }
        return Arrays.equals(field1, field2);
    }

    public static boolean equals(long[] field1, long[] field2) {
        if (field1 == null || field1.length == 0) {
            return field2 == null || field2.length == 0;
        }
        return Arrays.equals(field1, field2);
    }

    public static boolean equals(float[] field1, float[] field2) {
        if (field1 == null || field1.length == 0) {
            return field2 == null || field2.length == 0;
        }
        return Arrays.equals(field1, field2);
    }

    public static boolean equals(double[] field1, double[] field2) {
        if (field1 == null || field1.length == 0) {
            return field2 == null || field2.length == 0;
        }
        return Arrays.equals(field1, field2);
    }

    public static boolean equals(boolean[] field1, boolean[] field2) {
        if (field1 == null || field1.length == 0) {
            return field2 == null || field2.length == 0;
        }
        return Arrays.equals(field1, field2);
    }

    public static boolean equals(byte[][] field1, byte[][] field2) {
        int length2;
        int index1 = 0;
        int length1 = field1 == null ? 0 : field1.length;
        int index2 = 0;
        int n = length2 = field2 == null ? 0 : field2.length;
        while (true) {
            boolean atEndOf2;
            if (index1 < length1 && field1[index1] == null) {
                ++index1;
                continue;
            }
            while (index2 < length2 && field2[index2] == null) {
                ++index2;
            }
            boolean atEndOf1 = index1 >= length1;
            boolean bl = atEndOf2 = index2 >= length2;
            if (atEndOf1 && atEndOf2) {
                return true;
            }
            if (atEndOf1 != atEndOf2) {
                return false;
            }
            if (!Arrays.equals(field1[index1], field2[index2])) {
                return false;
            }
            ++index1;
            ++index2;
        }
    }

    public static boolean equals(Object[] field1, Object[] field2) {
        int length2;
        int index1 = 0;
        int length1 = field1 == null ? 0 : field1.length;
        int index2 = 0;
        int n = length2 = field2 == null ? 0 : field2.length;
        while (true) {
            boolean atEndOf2;
            if (index1 < length1 && field1[index1] == null) {
                ++index1;
                continue;
            }
            while (index2 < length2 && field2[index2] == null) {
                ++index2;
            }
            boolean atEndOf1 = index1 >= length1;
            boolean bl = atEndOf2 = index2 >= length2;
            if (atEndOf1 && atEndOf2) {
                return true;
            }
            if (atEndOf1 != atEndOf2) {
                return false;
            }
            if (!field1[index1].equals(field2[index2])) {
                return false;
            }
            ++index1;
            ++index2;
        }
    }

    public static int hashCode(int[] field) {
        return field == null || field.length == 0 ? 0 : Arrays.hashCode(field);
    }

    public static int hashCode(long[] field) {
        return field == null || field.length == 0 ? 0 : Arrays.hashCode(field);
    }

    public static int hashCode(float[] field) {
        return field == null || field.length == 0 ? 0 : Arrays.hashCode(field);
    }

    public static int hashCode(double[] field) {
        return field == null || field.length == 0 ? 0 : Arrays.hashCode(field);
    }

    public static int hashCode(boolean[] field) {
        return field == null || field.length == 0 ? 0 : Arrays.hashCode(field);
    }

    public static int hashCode(byte[][] field) {
        int size;
        int result = 0;
        int n = size = field == null ? 0 : field.length;
        for (int i = 0; i < size; ++i) {
            byte[] element = field[i];
            if (element == null) continue;
            result = 31 * result + Arrays.hashCode(element);
        }
        return result;
    }

    public static int hashCode(Object[] field) {
        int size;
        int result = 0;
        int n = size = field == null ? 0 : field.length;
        for (int i = 0; i < size; ++i) {
            Object element = field[i];
            if (element == null) continue;
            result = 31 * result + element.hashCode();
        }
        return result;
    }

    private static Object primitiveDefaultValue(int type) {
        switch (type) {
            case 8: {
                return Boolean.FALSE;
            }
            case 12: {
                return WireFormatNano.EMPTY_BYTES;
            }
            case 9: {
                return "";
            }
            case 2: {
                return Float.valueOf(0.0f);
            }
            case 1: {
                return 0.0;
            }
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                return 0;
            }
            case 3: 
            case 4: 
            case 6: 
            case 16: 
            case 18: {
                return 0L;
            }
        }
        throw new IllegalArgumentException("Type: " + type + " is not a primitive type.");
    }

    public static final <K, V> Map<K, V> mergeMapEntry(CodedInputByteBufferNano input, Map<K, V> map, MapFactories.MapFactory mapFactory, int keyType, int valueType, V value, int keyTag, int valueTag) throws IOException {
        int tag;
        map = mapFactory.forMap(map);
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        Object key = null;
        while ((tag = input.readTag()) != 0) {
            if (tag == keyTag) {
                key = input.readPrimitiveField(keyType);
                continue;
            }
            if (tag == valueTag) {
                if (valueType == 11) {
                    input.readMessage((MessageNano)value);
                    continue;
                }
                value = input.readPrimitiveField(valueType);
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        input.checkLastTagWas(0);
        input.popLimit(oldLimit);
        if (key == null) {
            key = InternalNano.primitiveDefaultValue(keyType);
        }
        if (value == null) {
            value = InternalNano.primitiveDefaultValue(valueType);
        }
        map.put(key, value);
        return map;
    }

    public static <K, V> void serializeMapField(CodedOutputByteBufferNano output, Map<K, V> map, int number, int keyType, int valueType) throws IOException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) {
                throw new IllegalStateException("keys and values in maps cannot be null");
            }
            int entrySize = CodedOutputByteBufferNano.computeFieldSize(1, keyType, key) + CodedOutputByteBufferNano.computeFieldSize(2, valueType, value);
            output.writeTag(number, 2);
            output.writeRawVarint32(entrySize);
            output.writeField(1, keyType, key);
            output.writeField(2, valueType, value);
        }
    }

    public static <K, V> int computeMapFieldSize(Map<K, V> map, int number, int keyType, int valueType) {
        int size = 0;
        int tagSize = CodedOutputByteBufferNano.computeTagSize(number);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) {
                throw new IllegalStateException("keys and values in maps cannot be null");
            }
            int entrySize = CodedOutputByteBufferNano.computeFieldSize(1, keyType, key) + CodedOutputByteBufferNano.computeFieldSize(2, valueType, value);
            size += tagSize + entrySize + CodedOutputByteBufferNano.computeRawVarint32Size(entrySize);
        }
        return size;
    }

    public static <K, V> boolean equals(Map<K, V> a, Map<K, V> b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b.size() == 0;
        }
        if (b == null) {
            return a.size() == 0;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : a.entrySet()) {
            if (!b.containsKey(entry.getKey())) {
                return false;
            }
            if (InternalNano.equalsMapValue(entry.getValue(), b.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsMapValue(Object a, Object b) {
        if (a == null || b == null) {
            throw new IllegalStateException("keys and values in maps cannot be null");
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        return a.equals(b);
    }

    public static <K, V> int hashCode(Map<K, V> map) {
        if (map == null) {
            return 0;
        }
        int result = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result += InternalNano.hashCodeForMap(entry.getKey()) ^ InternalNano.hashCodeForMap(entry.getValue());
        }
        return result;
    }

    private static int hashCodeForMap(Object o) {
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        return o.hashCode();
    }

    public static void cloneUnknownFieldData(ExtendableMessageNano original, ExtendableMessageNano cloned) {
        if (original.unknownFieldData != null) {
            cloned.unknownFieldData = original.unknownFieldData.clone();
        }
    }
}

