/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shaded.com.google.protobuf.nano;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.ratis.shaded.com.google.protobuf.nano.CodedInputByteBufferNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.CodedOutputByteBufferNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.ExtendableMessageNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.MessageNano;
import org.apache.ratis.shaded.com.google.protobuf.nano.UnknownFieldData;
import org.apache.ratis.shaded.com.google.protobuf.nano.WireFormatNano;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension<M extends ExtendableMessageNano<M>, T> {
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT64 = 3;
    public static final int TYPE_UINT64 = 4;
    public static final int TYPE_INT32 = 5;
    public static final int TYPE_FIXED64 = 6;
    public static final int TYPE_FIXED32 = 7;
    public static final int TYPE_BOOL = 8;
    public static final int TYPE_STRING = 9;
    public static final int TYPE_GROUP = 10;
    public static final int TYPE_MESSAGE = 11;
    public static final int TYPE_BYTES = 12;
    public static final int TYPE_UINT32 = 13;
    public static final int TYPE_ENUM = 14;
    public static final int TYPE_SFIXED32 = 15;
    public static final int TYPE_SFIXED64 = 16;
    public static final int TYPE_SINT32 = 17;
    public static final int TYPE_SINT64 = 18;
    protected final int type;
    protected final Class<T> clazz;
    public final int tag;
    protected final boolean repeated;

    @Deprecated
    public static <M extends ExtendableMessageNano<M>, T extends MessageNano> Extension<M, T> createMessageTyped(int type, Class<T> clazz, int tag) {
        return new Extension<M, T>(type, clazz, tag, false);
    }

    public static <M extends ExtendableMessageNano<M>, T extends MessageNano> Extension<M, T> createMessageTyped(int type, Class<T> clazz, long tag) {
        return new Extension<M, T>(type, clazz, (int)tag, false);
    }

    public static <M extends ExtendableMessageNano<M>, T extends MessageNano> Extension<M, T[]> createRepeatedMessageTyped(int type, Class<T[]> clazz, long tag) {
        return new Extension<M, T[]>(type, clazz, (int)tag, true);
    }

    public static <M extends ExtendableMessageNano<M>, T> Extension<M, T> createPrimitiveTyped(int type, Class<T> clazz, long tag) {
        return new PrimitiveExtension(type, clazz, (int)tag, false, 0, 0);
    }

    public static <M extends ExtendableMessageNano<M>, T> Extension<M, T> createRepeatedPrimitiveTyped(int type, Class<T> clazz, long tag, long nonPackedTag, long packedTag) {
        return new PrimitiveExtension(type, clazz, (int)tag, true, (int)nonPackedTag, (int)packedTag);
    }

    private Extension(int type, Class<T> clazz, int tag, boolean repeated) {
        this.type = type;
        this.clazz = clazz;
        this.tag = tag;
        this.repeated = repeated;
    }

    final T getValueFrom(List<UnknownFieldData> unknownFields) {
        if (unknownFields == null) {
            return null;
        }
        return this.repeated ? this.getRepeatedValueFrom(unknownFields) : this.getSingularValueFrom(unknownFields);
    }

    private T getRepeatedValueFrom(List<UnknownFieldData> unknownFields) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (int i = 0; i < unknownFields.size(); ++i) {
            UnknownFieldData data = unknownFields.get(i);
            if (data.bytes.length == 0) continue;
            this.readDataInto(data, resultList);
        }
        int resultSize = resultList.size();
        if (resultSize == 0) {
            return null;
        }
        T result = this.clazz.cast(Array.newInstance(this.clazz.getComponentType(), resultSize));
        for (int i = 0; i < resultSize; ++i) {
            Array.set(result, i, resultList.get(i));
        }
        return result;
    }

    private T getSingularValueFrom(List<UnknownFieldData> unknownFields) {
        if (unknownFields.isEmpty()) {
            return null;
        }
        UnknownFieldData lastData = unknownFields.get(unknownFields.size() - 1);
        return this.clazz.cast(this.readData(CodedInputByteBufferNano.newInstance(lastData.bytes)));
    }

    protected Object readData(CodedInputByteBufferNano input) {
        Class<Object> messageType = this.repeated ? this.clazz.getComponentType() : this.clazz;
        try {
            switch (this.type) {
                case 10: {
                    MessageNano group = (MessageNano)messageType.newInstance();
                    input.readGroup(group, WireFormatNano.getTagFieldNumber(this.tag));
                    return group;
                }
                case 11: {
                    MessageNano message = (MessageNano)messageType.newInstance();
                    input.readMessage(message);
                    return message;
                }
            }
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Error creating instance of class " + messageType, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error creating instance of class " + messageType, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading extension field", e);
        }
    }

    protected void readDataInto(UnknownFieldData data, List<Object> resultList) {
        resultList.add(this.readData(CodedInputByteBufferNano.newInstance(data.bytes)));
    }

    void writeTo(Object value, CodedOutputByteBufferNano output) throws IOException {
        if (this.repeated) {
            this.writeRepeatedData(value, output);
        } else {
            this.writeSingularData(value, output);
        }
    }

    protected void writeSingularData(Object value, CodedOutputByteBufferNano out) {
        try {
            out.writeRawVarint32(this.tag);
            switch (this.type) {
                case 10: {
                    MessageNano groupValue = (MessageNano)value;
                    int fieldNumber = WireFormatNano.getTagFieldNumber(this.tag);
                    out.writeGroupNoTag(groupValue);
                    out.writeTag(fieldNumber, 4);
                    break;
                }
                case 11: {
                    MessageNano messageValue = (MessageNano)value;
                    out.writeMessageNoTag(messageValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + this.type);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeRepeatedData(Object array, CodedOutputByteBufferNano output) {
        int arrayLength = Array.getLength(array);
        for (int i = 0; i < arrayLength; ++i) {
            Object element = Array.get(array, i);
            if (element == null) continue;
            this.writeSingularData(element, output);
        }
    }

    int computeSerializedSize(Object value) {
        if (this.repeated) {
            return this.computeRepeatedSerializedSize(value);
        }
        return this.computeSingularSerializedSize(value);
    }

    protected int computeRepeatedSerializedSize(Object array) {
        int size = 0;
        int arrayLength = Array.getLength(array);
        for (int i = 0; i < arrayLength; ++i) {
            Object element = Array.get(array, i);
            if (element == null) continue;
            size += this.computeSingularSerializedSize(Array.get(array, i));
        }
        return size;
    }

    protected int computeSingularSerializedSize(Object value) {
        int fieldNumber = WireFormatNano.getTagFieldNumber(this.tag);
        switch (this.type) {
            case 10: {
                MessageNano groupValue = (MessageNano)value;
                return CodedOutputByteBufferNano.computeGroupSize(fieldNumber, groupValue);
            }
            case 11: {
                MessageNano messageValue = (MessageNano)value;
                return CodedOutputByteBufferNano.computeMessageSize(fieldNumber, messageValue);
            }
        }
        throw new IllegalArgumentException("Unknown type " + this.type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitiveExtension<M extends ExtendableMessageNano<M>, T>
    extends Extension<M, T> {
        private final int nonPackedTag;
        private final int packedTag;

        public PrimitiveExtension(int type, Class<T> clazz, int tag, boolean repeated, int nonPackedTag, int packedTag) {
            super(type, clazz, tag, repeated);
            this.nonPackedTag = nonPackedTag;
            this.packedTag = packedTag;
        }

        @Override
        protected Object readData(CodedInputByteBufferNano input) {
            try {
                return input.readPrimitiveField(this.type);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error reading extension field", e);
            }
        }

        @Override
        protected void readDataInto(UnknownFieldData data, List<Object> resultList) {
            if (data.tag == this.nonPackedTag) {
                resultList.add(this.readData(CodedInputByteBufferNano.newInstance(data.bytes)));
            } else {
                CodedInputByteBufferNano buffer = CodedInputByteBufferNano.newInstance(data.bytes);
                try {
                    buffer.pushLimit(buffer.readRawVarint32());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error reading extension field", e);
                }
                while (!buffer.isAtEnd()) {
                    resultList.add(this.readData(buffer));
                }
            }
        }

        @Override
        protected final void writeSingularData(Object value, CodedOutputByteBufferNano output) {
            try {
                output.writeRawVarint32(this.tag);
                switch (this.type) {
                    case 1: {
                        Double doubleValue = (Double)value;
                        output.writeDoubleNoTag(doubleValue);
                        break;
                    }
                    case 2: {
                        Float floatValue = (Float)value;
                        output.writeFloatNoTag(floatValue.floatValue());
                        break;
                    }
                    case 3: {
                        Long int64Value = (Long)value;
                        output.writeInt64NoTag(int64Value);
                        break;
                    }
                    case 4: {
                        Long uint64Value = (Long)value;
                        output.writeUInt64NoTag(uint64Value);
                        break;
                    }
                    case 5: {
                        Integer int32Value = (Integer)value;
                        output.writeInt32NoTag(int32Value);
                        break;
                    }
                    case 6: {
                        Long fixed64Value = (Long)value;
                        output.writeFixed64NoTag(fixed64Value);
                        break;
                    }
                    case 7: {
                        Integer fixed32Value = (Integer)value;
                        output.writeFixed32NoTag(fixed32Value);
                        break;
                    }
                    case 8: {
                        Boolean boolValue = (Boolean)value;
                        output.writeBoolNoTag(boolValue);
                        break;
                    }
                    case 9: {
                        String stringValue = (String)value;
                        output.writeStringNoTag(stringValue);
                        break;
                    }
                    case 12: {
                        byte[] bytesValue = (byte[])value;
                        output.writeBytesNoTag(bytesValue);
                        break;
                    }
                    case 13: {
                        Integer uint32Value = (Integer)value;
                        output.writeUInt32NoTag(uint32Value);
                        break;
                    }
                    case 14: {
                        Integer enumValue = (Integer)value;
                        output.writeEnumNoTag(enumValue);
                        break;
                    }
                    case 15: {
                        Integer sfixed32Value = (Integer)value;
                        output.writeSFixed32NoTag(sfixed32Value);
                        break;
                    }
                    case 16: {
                        Long sfixed64Value = (Long)value;
                        output.writeSFixed64NoTag(sfixed64Value);
                        break;
                    }
                    case 17: {
                        Integer sint32Value = (Integer)value;
                        output.writeSInt32NoTag(sint32Value);
                        break;
                    }
                    case 18: {
                        Long sint64Value = (Long)value;
                        output.writeSInt64NoTag(sint64Value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + this.type);
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        protected void writeRepeatedData(Object array, CodedOutputByteBufferNano output) {
            if (this.tag == this.nonPackedTag) {
                super.writeRepeatedData(array, output);
            } else if (this.tag == this.packedTag) {
                int arrayLength = Array.getLength(array);
                int dataSize = this.computePackedDataSize(array);
                try {
                    output.writeRawVarint32(this.tag);
                    output.writeRawVarint32(dataSize);
                    switch (this.type) {
                        case 8: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeBoolNoTag(Array.getBoolean(array, i));
                            }
                        }
                        case 7: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeFixed32NoTag(Array.getInt(array, i));
                            }
                        }
                        case 15: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeSFixed32NoTag(Array.getInt(array, i));
                            }
                        }
                        case 2: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeFloatNoTag(Array.getFloat(array, i));
                            }
                        }
                        case 6: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeFixed64NoTag(Array.getLong(array, i));
                            }
                        }
                        case 16: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeSFixed64NoTag(Array.getLong(array, i));
                            }
                        }
                        case 1: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeDoubleNoTag(Array.getDouble(array, i));
                            }
                        }
                        case 5: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeInt32NoTag(Array.getInt(array, i));
                            }
                        }
                        case 17: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeSInt32NoTag(Array.getInt(array, i));
                            }
                        }
                        case 13: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeUInt32NoTag(Array.getInt(array, i));
                            }
                        }
                        case 3: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeInt64NoTag(Array.getLong(array, i));
                            }
                        }
                        case 18: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeSInt64NoTag(Array.getLong(array, i));
                            }
                        }
                        case 4: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeUInt64NoTag(Array.getLong(array, i));
                            }
                        }
                        case 14: {
                            for (int i = 0; i < arrayLength; ++i) {
                                output.writeEnumNoTag(Array.getInt(array, i));
                            }
                        }
                        default: {
                            throw new IllegalArgumentException("Unpackable type " + this.type);
                        }
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                throw new IllegalArgumentException("Unexpected repeated extension tag " + this.tag + ", unequal to both non-packed variant " + this.nonPackedTag + " and packed variant " + this.packedTag);
            }
        }

        private int computePackedDataSize(Object array) {
            int dataSize = 0;
            int arrayLength = Array.getLength(array);
            switch (this.type) {
                case 8: {
                    dataSize = arrayLength;
                    break;
                }
                case 2: 
                case 7: 
                case 15: {
                    dataSize = arrayLength * 4;
                    break;
                }
                case 1: 
                case 6: 
                case 16: {
                    dataSize = arrayLength * 8;
                    break;
                }
                case 5: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(Array.getInt(array, i));
                    }
                    break;
                }
                case 17: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeSInt32SizeNoTag(Array.getInt(array, i));
                    }
                    break;
                }
                case 13: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeUInt32SizeNoTag(Array.getInt(array, i));
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeInt64SizeNoTag(Array.getLong(array, i));
                    }
                    break;
                }
                case 18: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeSInt64SizeNoTag(Array.getLong(array, i));
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeUInt64SizeNoTag(Array.getLong(array, i));
                    }
                    break;
                }
                case 14: {
                    for (int i = 0; i < arrayLength; ++i) {
                        dataSize += CodedOutputByteBufferNano.computeEnumSizeNoTag(Array.getInt(array, i));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected non-packable type " + this.type);
                }
            }
            return dataSize;
        }

        @Override
        protected int computeRepeatedSerializedSize(Object array) {
            if (this.tag == this.nonPackedTag) {
                return super.computeRepeatedSerializedSize(array);
            }
            if (this.tag == this.packedTag) {
                int dataSize = this.computePackedDataSize(array);
                int payloadSize = dataSize + CodedOutputByteBufferNano.computeRawVarint32Size(dataSize);
                return payloadSize + CodedOutputByteBufferNano.computeRawVarint32Size(this.tag);
            }
            throw new IllegalArgumentException("Unexpected repeated extension tag " + this.tag + ", unequal to both non-packed variant " + this.nonPackedTag + " and packed variant " + this.packedTag);
        }

        @Override
        protected final int computeSingularSerializedSize(Object value) {
            int fieldNumber = WireFormatNano.getTagFieldNumber(this.tag);
            switch (this.type) {
                case 1: {
                    Double doubleValue = (Double)value;
                    return CodedOutputByteBufferNano.computeDoubleSize(fieldNumber, doubleValue);
                }
                case 2: {
                    Float floatValue = (Float)value;
                    return CodedOutputByteBufferNano.computeFloatSize(fieldNumber, floatValue.floatValue());
                }
                case 3: {
                    Long int64Value = (Long)value;
                    return CodedOutputByteBufferNano.computeInt64Size(fieldNumber, int64Value);
                }
                case 4: {
                    Long uint64Value = (Long)value;
                    return CodedOutputByteBufferNano.computeUInt64Size(fieldNumber, uint64Value);
                }
                case 5: {
                    Integer int32Value = (Integer)value;
                    return CodedOutputByteBufferNano.computeInt32Size(fieldNumber, int32Value);
                }
                case 6: {
                    Long fixed64Value = (Long)value;
                    return CodedOutputByteBufferNano.computeFixed64Size(fieldNumber, fixed64Value);
                }
                case 7: {
                    Integer fixed32Value = (Integer)value;
                    return CodedOutputByteBufferNano.computeFixed32Size(fieldNumber, fixed32Value);
                }
                case 8: {
                    Boolean boolValue = (Boolean)value;
                    return CodedOutputByteBufferNano.computeBoolSize(fieldNumber, boolValue);
                }
                case 9: {
                    String stringValue = (String)value;
                    return CodedOutputByteBufferNano.computeStringSize(fieldNumber, stringValue);
                }
                case 12: {
                    byte[] bytesValue = (byte[])value;
                    return CodedOutputByteBufferNano.computeBytesSize(fieldNumber, bytesValue);
                }
                case 13: {
                    Integer uint32Value = (Integer)value;
                    return CodedOutputByteBufferNano.computeUInt32Size(fieldNumber, uint32Value);
                }
                case 14: {
                    Integer enumValue = (Integer)value;
                    return CodedOutputByteBufferNano.computeEnumSize(fieldNumber, enumValue);
                }
                case 15: {
                    Integer sfixed32Value = (Integer)value;
                    return CodedOutputByteBufferNano.computeSFixed32Size(fieldNumber, sfixed32Value);
                }
                case 16: {
                    Long sfixed64Value = (Long)value;
                    return CodedOutputByteBufferNano.computeSFixed64Size(fieldNumber, sfixed64Value);
                }
                case 17: {
                    Integer sint32Value = (Integer)value;
                    return CodedOutputByteBufferNano.computeSInt32Size(fieldNumber, sint32Value);
                }
                case 18: {
                    Long sint64Value = (Long)value;
                    return CodedOutputByteBufferNano.computeSInt64Size(fieldNumber, sint64Value);
                }
            }
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
    }
}

