/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import java.net.URI;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"deletes a volume if it is empty"})
public class DeleteVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the SCM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        if (ozoneURI.getPath().isEmpty()) {
            throw new OzoneClientException("Volume name is required to delete a volume");
        }
        String volumeName = ozoneURI.getPath().substring(1);
        if (this.isVerbose()) {
            System.out.printf("Volume name : %s%n", volumeName);
        }
        this.client.getObjectStore().deleteVolume(volumeName);
        System.out.printf("Volume %s is deleted%n", volumeName);
        return null;
    }
}

