/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.volume;

import java.net.URI;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates a volume for the specified user"})
public class CreateVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the SCM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of of the volume"}, required=true)
    private String userName;
    @CommandLine.Option(names={"--quota", "-q"}, description={"Quota of the newly created volume (eg. 1G)"})
    private String quota;
    @CommandLine.Option(names={"--root"}, description={"Development flag to execute the command as the admin (hdfs) user."})
    private boolean root;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        String volumeName = ozoneURI.getPath().replaceAll("^/+", "");
        if (volumeName.isEmpty()) {
            throw new OzoneClientException("Volume name is required to create a volume");
        }
        if (this.isVerbose()) {
            System.out.printf("Volume name : %s%n", volumeName);
        }
        String rootName = this.root ? "hdfs" : System.getProperty("user.name");
        VolumeArgs.Builder volumeArgsBuilder = VolumeArgs.newBuilder().setAdmin(rootName).setOwner(this.userName);
        if (this.quota != null) {
            volumeArgsBuilder.setQuota(this.quota);
        }
        this.client.getObjectStore().createVolume(volumeName, volumeArgsBuilder.build());
        if (this.isVerbose()) {
            OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
            System.out.printf("%s%n", JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString((Object)OzoneClientUtils.asVolumeInfo((OzoneVolume)vol))));
        }
        return null;
    }
}

