/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.rest.response.KeyInfo;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"list all keys in a given bucket"})
public class ListKeyHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the SCM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--length", "-l"}, description={"Limit of the max results"}, defaultValue="100")
    private int maxKeys;
    @CommandLine.Option(names={"--start", "-s"}, description={"The first key to start the listing"})
    private String startKey;
    @CommandLine.Option(names={"--prefix", "-p"}, description={"Prefix to filter the key"})
    private String prefix;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        if (path.getNameCount() < 2) {
            throw new OzoneClientException("volume/bucket is required in listKey");
        }
        if (this.maxKeys < 1) {
            throw new IllegalArgumentException("the length should be a positive number");
        }
        String volumeName = path.getName(0).toString();
        String bucketName = path.getName(1).toString();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("bucket Name : %s%n", bucketName);
        }
        OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        Iterator keyIterator = bucket.listKeys(this.prefix, this.startKey);
        ArrayList<KeyInfo> keyInfos = new ArrayList<KeyInfo>();
        while (this.maxKeys > 0 && keyIterator.hasNext()) {
            KeyInfo key = OzoneClientUtils.asKeyInfo((OzoneKey)((OzoneKey)keyIterator.next()));
            keyInfos.add(key);
            --this.maxKeys;
        }
        if (this.isVerbose()) {
            System.out.printf("Found : %d keys for bucket %s in volume : %s ", keyInfos.size(), bucketName, volumeName);
        }
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString(keyInfos)));
        return null;
    }
}

