/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.keys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Gets a specific key from ozone server"})
public class GetKeyHandler
extends Handler {
    @CommandLine.Parameters(index="0", arity="1..1", description={"URI of the volume/bucket/key.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the SCM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Parameters(index="1", arity="1..1", description={"File path to download the key to"})
    private String fileName;

    @Override
    public Void call() throws Exception {
        URI ozoneURI = this.verifyURI(this.uri);
        Path path = Paths.get(ozoneURI.getPath(), new String[0]);
        if (path.getNameCount() < 3) {
            throw new OzoneClientException("volume/bucket/key name required in putKey");
        }
        String volumeName = path.getName(0).toString();
        String bucketName = path.getName(1).toString();
        String keyName = path.getName(2).toString();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
            System.out.printf("Key Name : %s%n", keyName);
        }
        Path dataFilePath = Paths.get(this.fileName, new String[0]);
        File dataFile = new File(this.fileName);
        if (dataFile.exists() && dataFile.isDirectory()) {
            dataFile = new File(this.fileName, keyName);
        }
        if (dataFile.exists()) {
            throw new OzoneClientException(this.fileName + "exists. Download will overwrite an existing file. Aborting.");
        }
        OzoneVolume vol = this.client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        OzoneInputStream keyInputStream = bucket.readKey(keyName);
        if (dataFilePath == null) {
            throw new OzoneClientException("Can not access the file \"" + this.fileName + "\"");
        }
        FileOutputStream outputStream = new FileOutputStream(dataFile);
        IOUtils.copyBytes((InputStream)keyInputStream, (OutputStream)outputStream, (int)new OzoneConfiguration().getInt("ozone.scm.chunk.size", 0x1000000));
        outputStream.close();
        if (this.isVerbose()) {
            FileInputStream stream = new FileInputStream(dataFile);
            String hash = DigestUtils.md5Hex((InputStream)stream);
            System.out.printf("Downloaded file hash : %s%n", hash);
            stream.close();
        }
        return null;
    }
}

