/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.common.collect.Lists;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerProtocolServerSideTranslatorPB
implements OzoneManagerProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolServerSideTranslatorPB.class);
    private final OzoneManagerProtocol impl;

    public OzoneManagerProtocolServerSideTranslatorPB(OzoneManagerProtocol impl) {
        this.impl = impl;
    }

    private OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof OMException) {
            OMException omException = (OMException)ex;
            switch (omException.getResult()) {
                case FAILED_VOLUME_ALREADY_EXISTS: {
                    return OzoneManagerProtocolProtos.Status.VOLUME_ALREADY_EXISTS;
                }
                case FAILED_TOO_MANY_USER_VOLUMES: {
                    return OzoneManagerProtocolProtos.Status.USER_TOO_MANY_VOLUMES;
                }
                case FAILED_VOLUME_NOT_FOUND: {
                    return OzoneManagerProtocolProtos.Status.VOLUME_NOT_FOUND;
                }
                case FAILED_VOLUME_NOT_EMPTY: {
                    return OzoneManagerProtocolProtos.Status.VOLUME_NOT_EMPTY;
                }
                case FAILED_USER_NOT_FOUND: {
                    return OzoneManagerProtocolProtos.Status.USER_NOT_FOUND;
                }
                case FAILED_BUCKET_ALREADY_EXISTS: {
                    return OzoneManagerProtocolProtos.Status.BUCKET_ALREADY_EXISTS;
                }
                case FAILED_BUCKET_NOT_FOUND: {
                    return OzoneManagerProtocolProtos.Status.BUCKET_NOT_FOUND;
                }
                case FAILED_BUCKET_NOT_EMPTY: {
                    return OzoneManagerProtocolProtos.Status.BUCKET_NOT_EMPTY;
                }
                case FAILED_KEY_ALREADY_EXISTS: {
                    return OzoneManagerProtocolProtos.Status.KEY_ALREADY_EXISTS;
                }
                case FAILED_KEY_NOT_FOUND: {
                    return OzoneManagerProtocolProtos.Status.KEY_NOT_FOUND;
                }
                case FAILED_INVALID_KEY_NAME: {
                    return OzoneManagerProtocolProtos.Status.INVALID_KEY_NAME;
                }
                case FAILED_KEY_ALLOCATION: {
                    return OzoneManagerProtocolProtos.Status.KEY_ALLOCATION_ERROR;
                }
                case FAILED_KEY_DELETION: {
                    return OzoneManagerProtocolProtos.Status.KEY_DELETION_ERROR;
                }
                case FAILED_KEY_RENAME: {
                    return OzoneManagerProtocolProtos.Status.KEY_RENAME_ERROR;
                }
                case FAILED_METADATA_ERROR: {
                    return OzoneManagerProtocolProtos.Status.METADATA_ERROR;
                }
                case OM_NOT_INITIALIZED: {
                    return OzoneManagerProtocolProtos.Status.OM_NOT_INITIALIZED;
                }
                case SCM_VERSION_MISMATCH_ERROR: {
                    return OzoneManagerProtocolProtos.Status.SCM_VERSION_MISMATCH_ERROR;
                }
            }
            return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unknown error occurs", (Throwable)ex);
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    public OzoneManagerProtocolProtos.CreateVolumeResponse createVolume(RpcController controller, OzoneManagerProtocolProtos.CreateVolumeRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.CreateVolumeResponse.Builder resp = OzoneManagerProtocolProtos.CreateVolumeResponse.newBuilder();
        resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        try {
            this.impl.createVolume(OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)request.getVolumeInfo()));
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.SetVolumePropertyResponse setVolumeProperty(RpcController controller, OzoneManagerProtocolProtos.SetVolumePropertyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.SetVolumePropertyResponse.Builder resp = OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder();
        resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        String volume = request.getVolumeName();
        try {
            if (request.hasQuotaInBytes()) {
                long quota = request.getQuotaInBytes();
                this.impl.setQuota(volume, quota);
            } else {
                String owner = request.getOwnerName();
                this.impl.setOwner(volume, owner);
            }
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccess(RpcController controller, OzoneManagerProtocolProtos.CheckVolumeAccessRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.CheckVolumeAccessResponse.Builder resp = OzoneManagerProtocolProtos.CheckVolumeAccessResponse.newBuilder();
        resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        try {
            boolean access = this.impl.checkVolumeAccess(request.getVolumeName(), request.getUserAcl());
            if (!access) {
                resp.setStatus(OzoneManagerProtocolProtos.Status.ACCESS_DENIED);
            }
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.InfoVolumeResponse infoVolume(RpcController controller, OzoneManagerProtocolProtos.InfoVolumeRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.InfoVolumeResponse.Builder resp = OzoneManagerProtocolProtos.InfoVolumeResponse.newBuilder();
        resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        String volume = request.getVolumeName();
        try {
            OmVolumeArgs ret = this.impl.getVolumeInfo(volume);
            resp.setVolumeInfo(ret.getProtobuf());
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.DeleteVolumeResponse deleteVolume(RpcController controller, OzoneManagerProtocolProtos.DeleteVolumeRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.DeleteVolumeResponse.Builder resp = OzoneManagerProtocolProtos.DeleteVolumeResponse.newBuilder();
        resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        try {
            this.impl.deleteVolume(request.getVolumeName());
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.ListVolumeResponse listVolumes(RpcController controller, OzoneManagerProtocolProtos.ListVolumeRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.ListVolumeResponse.Builder resp = OzoneManagerProtocolProtos.ListVolumeResponse.newBuilder();
        List result = Lists.newArrayList();
        try {
            if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER) {
                result = this.impl.listVolumeByUser(request.getUserName(), request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
            } else if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER) {
                result = this.impl.listAllVolumes(request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
            }
            if (result == null) {
                throw new ServiceException("Failed to get volumes for given scope " + request.getScope());
            }
            result.forEach(item -> resp.addVolumeInfo(item.getProtobuf()));
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.CreateBucketResponse createBucket(RpcController controller, OzoneManagerProtocolProtos.CreateBucketRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.CreateBucketResponse.Builder resp = OzoneManagerProtocolProtos.CreateBucketResponse.newBuilder();
        try {
            this.impl.createBucket(OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)request.getBucketInfo()));
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.InfoBucketResponse infoBucket(RpcController controller, OzoneManagerProtocolProtos.InfoBucketRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.InfoBucketResponse.Builder resp = OzoneManagerProtocolProtos.InfoBucketResponse.newBuilder();
        try {
            OmBucketInfo omBucketInfo = this.impl.getBucketInfo(request.getVolumeName(), request.getBucketName());
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
            resp.setBucketInfo(omBucketInfo.getProtobuf());
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.LocateKeyResponse createKey(RpcController controller, OzoneManagerProtocolProtos.LocateKeyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.LocateKeyResponse.Builder resp = OzoneManagerProtocolProtos.LocateKeyResponse.newBuilder();
        try {
            OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
            HddsProtos.ReplicationType type = keyArgs.hasType() ? keyArgs.getType() : null;
            HddsProtos.ReplicationFactor factor = keyArgs.hasFactor() ? keyArgs.getFactor() : null;
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setDataSize(keyArgs.getDataSize()).setType(type).setFactor(factor).build();
            if (keyArgs.hasDataSize()) {
                omKeyArgs.setDataSize(keyArgs.getDataSize());
            } else {
                omKeyArgs.setDataSize(0L);
            }
            OpenKeySession openKey = this.impl.openKey(omKeyArgs);
            resp.setKeyInfo(openKey.getKeyInfo().getProtobuf());
            resp.setID(openKey.getId());
            resp.setOpenVersion(openKey.getOpenVersion());
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.LocateKeyResponse lookupKey(RpcController controller, OzoneManagerProtocolProtos.LocateKeyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.LocateKeyResponse.Builder resp = OzoneManagerProtocolProtos.LocateKeyResponse.newBuilder();
        try {
            OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
            OmKeyInfo keyInfo = this.impl.lookupKey(omKeyArgs);
            resp.setKeyInfo(keyInfo.getProtobuf());
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.RenameKeyResponse renameKey(RpcController controller, OzoneManagerProtocolProtos.RenameKeyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.RenameKeyResponse.Builder resp = OzoneManagerProtocolProtos.RenameKeyResponse.newBuilder();
        try {
            OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
            this.impl.renameKey(omKeyArgs, request.getToKeyName());
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.SetBucketPropertyResponse setBucketProperty(RpcController controller, OzoneManagerProtocolProtos.SetBucketPropertyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.SetBucketPropertyResponse.Builder resp = OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder();
        try {
            this.impl.setBucketProperty(OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)request.getBucketArgs()));
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.LocateKeyResponse deleteKey(RpcController controller, OzoneManagerProtocolProtos.LocateKeyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.LocateKeyResponse.Builder resp = OzoneManagerProtocolProtos.LocateKeyResponse.newBuilder();
        try {
            OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
            this.impl.deleteKey(omKeyArgs);
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.DeleteBucketResponse deleteBucket(RpcController controller, OzoneManagerProtocolProtos.DeleteBucketRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.DeleteBucketResponse.Builder resp = OzoneManagerProtocolProtos.DeleteBucketResponse.newBuilder();
        resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        try {
            this.impl.deleteBucket(request.getVolumeName(), request.getBucketName());
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.ListBucketsResponse listBuckets(RpcController controller, OzoneManagerProtocolProtos.ListBucketsRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.ListBucketsResponse.Builder resp = OzoneManagerProtocolProtos.ListBucketsResponse.newBuilder();
        try {
            List buckets = this.impl.listBuckets(request.getVolumeName(), request.getStartKey(), request.getPrefix(), request.getCount());
            for (OmBucketInfo bucket : buckets) {
                resp.addBucketInfo(bucket.getProtobuf());
            }
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.ListKeysResponse listKeys(RpcController controller, OzoneManagerProtocolProtos.ListKeysRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.ListKeysResponse.Builder resp = OzoneManagerProtocolProtos.ListKeysResponse.newBuilder();
        try {
            List keys = this.impl.listKeys(request.getVolumeName(), request.getBucketName(), request.getStartKey(), request.getPrefix(), request.getCount());
            for (OmKeyInfo key : keys) {
                resp.addKeyInfo(key.getProtobuf());
            }
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.CommitKeyResponse commitKey(RpcController controller, OzoneManagerProtocolProtos.CommitKeyRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.CommitKeyResponse.Builder resp = OzoneManagerProtocolProtos.CommitKeyResponse.newBuilder();
        try {
            OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
            HddsProtos.ReplicationType type = keyArgs.hasType() ? keyArgs.getType() : null;
            HddsProtos.ReplicationFactor factor = keyArgs.hasFactor() ? keyArgs.getFactor() : null;
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setLocationInfoList(keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList())).setType(type).setFactor(factor).setDataSize(keyArgs.getDataSize()).build();
            this.impl.commitKey(omKeyArgs, request.getClientID());
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.AllocateBlockResponse allocateBlock(RpcController controller, OzoneManagerProtocolProtos.AllocateBlockRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.AllocateBlockResponse.Builder resp = OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder();
        try {
            OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
            OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
            OmKeyLocationInfo newLocation = this.impl.allocateBlock(omKeyArgs, request.getClientID());
            resp.setKeyLocation(newLocation.getProtobuf());
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }

    public OzoneManagerProtocolProtos.ServiceListResponse getServiceList(RpcController controller, OzoneManagerProtocolProtos.ServiceListRequest request) throws ServiceException {
        OzoneManagerProtocolProtos.ServiceListResponse.Builder resp = OzoneManagerProtocolProtos.ServiceListResponse.newBuilder();
        try {
            resp.addAllServiceInfo((Iterable)this.impl.getServiceList().stream().map(ServiceInfo::getProtobuf).collect(Collectors.toList()));
            resp.setStatus(OzoneManagerProtocolProtos.Status.OK);
        }
        catch (IOException e) {
            resp.setStatus(this.exceptionToResponseStatus(e));
        }
        return resp.build();
    }
}

