/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.BucketManagerImpl;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMMXBean;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManagerHttpServer;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.VolumeManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class OzoneManager
extends ServiceRuntimeInfoImpl
implements OzoneManagerProtocol,
OMMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManager.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
    private static final String USAGE = "Usage: \n ozone om [genericOptions] [ " + StartupOption.CREATEOBJECTSTORE.getName() + " ]\n ozone om [ " + StartupOption.HELP.getName() + " ]\n";
    private final OzoneConfiguration configuration;
    private final RPC.Server omRpcServer;
    private final InetSocketAddress omRpcAddress;
    private final OMMetadataManager metadataManager;
    private final VolumeManager volumeManager;
    private final BucketManager bucketManager;
    private final KeyManager keyManager;
    private final OMMetrics metrics;
    private final OzoneManagerHttpServer httpServer;
    private final OMStorage omStorage;
    private final ScmBlockLocationProtocol scmBlockClient;
    private final StorageContainerLocationProtocol scmContainerClient;
    private ObjectName omInfoBeanName;

    private OzoneManager(OzoneConfiguration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf);
        this.configuration = conf;
        this.omStorage = new OMStorage(conf);
        this.scmBlockClient = OzoneManager.getScmBlockClient(this.configuration);
        this.scmContainerClient = OzoneManager.getScmContainerClient(this.configuration);
        if (this.omStorage.getState() != Storage.StorageState.INITIALIZED) {
            throw new OMException("OM not initialized.", OMException.ResultCodes.OM_NOT_INITIALIZED);
        }
        ScmInfo scmInfo = this.scmBlockClient.getScmInfo();
        if (!scmInfo.getClusterId().equals(this.omStorage.getClusterID()) || !scmInfo.getScmId().equals(this.omStorage.getScmId())) {
            throw new OMException("SCM version info mismatch.", OMException.ResultCodes.SCM_VERSION_MISMATCH_ERROR);
        }
        int handlerCount = conf.getInt("ozone.om.handler.count.key", 20);
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService omService = OzoneManagerProtocolProtos.OzoneManagerService.newReflectiveBlockingService((OzoneManagerProtocolProtos.OzoneManagerService.BlockingInterface)new OzoneManagerProtocolServerSideTranslatorPB(this));
        InetSocketAddress omNodeRpcAddr = OmUtils.getOmAddress((Configuration)this.configuration);
        this.omRpcServer = OzoneManager.startRpcServer(this.configuration, omNodeRpcAddr, OzoneManagerProtocolPB.class, omService, handlerCount);
        this.omRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)this.configuration, (String)"ozone.om.address", (InetSocketAddress)omNodeRpcAddr, (RPC.Server)this.omRpcServer);
        this.metadataManager = new OmMetadataManagerImpl(this.configuration);
        this.volumeManager = new VolumeManagerImpl(this.metadataManager, this.configuration);
        this.bucketManager = new BucketManagerImpl(this.metadataManager);
        this.metrics = OMMetrics.create();
        this.keyManager = new KeyManagerImpl(this.scmBlockClient, this.metadataManager, this.configuration, this.omStorage.getOmId());
        this.httpServer = new OzoneManagerHttpServer((Configuration)this.configuration, this);
    }

    private static ScmBlockLocationProtocol getScmBlockClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        InetSocketAddress scmBlockAddress = HddsUtils.getScmAddressForBlockClients((Configuration)conf);
        ScmBlockLocationProtocolClientSideTranslatorPB scmBlockLocationClient = new ScmBlockLocationProtocolClientSideTranslatorPB((ScmBlockLocationProtocolPB)RPC.getProxy(ScmBlockLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmBlockAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        return scmBlockLocationClient;
    }

    private static StorageContainerLocationProtocol getScmContainerClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddr = HddsUtils.getScmAddressForClients((Configuration)conf);
        StorageContainerLocationProtocolClientSideTranslatorPB scmContainerClient = new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        return scmContainerClient;
    }

    private static RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(null).build();
        DFSUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        return rpcServer;
    }

    public static void main(String[] argv) throws IOException {
        if (DFSUtil.parseHelpArgument((String[])argv, (String)USAGE, (PrintStream)System.out, (boolean)true)) {
            System.exit(0);
        }
        try {
            OzoneManager om;
            OzoneConfiguration conf = new OzoneConfiguration();
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            if (!hParser.isParseSuccessful()) {
                System.err.println("USAGE: " + USAGE + " \n");
                GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
                System.exit(1);
            }
            if ((om = OzoneManager.createOm(hParser.getRemainingArgs(), conf, true)) != null) {
                om.start();
                om.join();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to start the OzoneManager.", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    private static void printUsage(PrintStream out) {
        out.println(USAGE + "\n");
    }

    @VisibleForTesting
    public static OzoneManager createOm(String[] argv, OzoneConfiguration conf) throws IOException {
        return OzoneManager.createOm(argv, conf, false);
    }

    private static OzoneManager createOm(String[] argv, OzoneConfiguration conf, boolean printBanner) throws IOException {
        StartupOption startOpt;
        if (!HddsUtils.isHddsEnabled((Configuration)conf)) {
            System.err.println("OM cannot be started in secure mode or when ozone.enabled is set to false");
            System.exit(1);
        }
        if ((startOpt = OzoneManager.parseArguments(argv)) == null) {
            OzoneManager.printUsage(System.err);
            ExitUtil.terminate((int)1);
            return null;
        }
        switch (startOpt) {
            case CREATEOBJECTSTORE: {
                if (printBanner) {
                    StringUtils.startupShutdownMessage(OzoneManager.class, (String[])argv, (Logger)LOG);
                }
                ExitUtil.terminate((int)(OzoneManager.omInit(conf) ? 0 : 1));
                return null;
            }
            case HELP: {
                OzoneManager.printUsage(System.err);
                ExitUtil.terminate((int)0);
                return null;
            }
        }
        if (argv == null) {
            argv = new String[]{};
        }
        if (printBanner) {
            StringUtils.startupShutdownMessage(OzoneManager.class, (String[])argv, (Logger)LOG);
        }
        return new OzoneManager(conf);
    }

    private static boolean omInit(OzoneConfiguration conf) throws IOException {
        OMStorage omStorage = new OMStorage(conf);
        Storage.StorageState state = omStorage.getState();
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                ScmBlockLocationProtocol scmBlockClient = OzoneManager.getScmBlockClient(conf);
                ScmInfo scmInfo = scmBlockClient.getScmInfo();
                String clusterId = scmInfo.getClusterId();
                String scmId = scmInfo.getScmId();
                if (clusterId == null || clusterId.isEmpty()) {
                    throw new IOException("Invalid Cluster ID");
                }
                if (scmId == null || scmId.isEmpty()) {
                    throw new IOException("Invalid SCM ID");
                }
                omStorage.setClusterId(clusterId);
                omStorage.setScmId(scmId);
                omStorage.initialize();
                System.out.println("OM initialization succeeded.Current cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID());
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize OM version file", (Throwable)ioe);
                return false;
            }
        }
        System.out.println("OM already initialized.Reusing existing cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID());
        return true;
    }

    private static StartupOption parseArguments(String[] args) {
        if (args == null || args.length == 0) {
            return StartupOption.REGULAR;
        }
        if (args.length == 1) {
            return StartupOption.parse(args[0]);
        }
        return null;
    }

    private static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    @VisibleForTesting
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @VisibleForTesting
    public ScmInfo getScmInfo() throws IOException {
        return this.scmBlockClient.getScmInfo();
    }

    @VisibleForTesting
    public OMStorage getOmStorage() {
        return this.omStorage;
    }

    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public OMMetrics getMetrics() {
        return this.metrics;
    }

    public void start() throws IOException {
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        DefaultMetricsSystem.initialize((String)"OzoneManager");
        this.metadataManager.start();
        this.keyManager.start();
        this.omRpcServer.start();
        this.httpServer.start();
        this.registerMXBean();
        this.setStartTime();
    }

    public void stop() {
        try {
            this.metadataManager.stop();
            this.omRpcServer.stop();
            this.keyManager.stop();
            this.httpServer.stop();
            this.metrics.unRegister();
            this.unregisterMXBean();
        }
        catch (Exception e) {
            LOG.error("OzoneManager stop failed.", (Throwable)e);
        }
    }

    public void join() {
        try {
            this.omRpcServer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during OzoneManager join.", (Throwable)e);
        }
    }

    public void createVolume(OmVolumeArgs args) throws IOException {
        try {
            this.metrics.incNumVolumeCreates();
            this.volumeManager.createVolume(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCreateFails();
            AUDIT.logWriteFailure(Level.ERROR, this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap()), (Throwable)ex);
            throw ex;
        }
    }

    public void setOwner(String volume, String owner) throws IOException {
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("owner", owner);
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setOwner(volume, owner);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_OWNER, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_OWNER, auditMap), (Throwable)ex);
            throw ex;
        }
    }

    public void setQuota(String volume, long quota) throws IOException {
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("quota", String.valueOf(quota));
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setQuota(volume, quota);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_QUOTA, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_QUOTA, auditMap), (Throwable)ex);
            throw ex;
        }
    }

    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("userAcl", userAcl == null ? null : userAcl.getName());
        try {
            this.metrics.incNumVolumeCheckAccesses();
            boolean bl = this.volumeManager.checkVolumeAccess(volume, userAcl);
            return bl;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCheckAccessFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap));
            }
        }
    }

    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        try {
            this.metrics.incNumVolumeInfos();
            OmVolumeArgs omVolumeArgs = this.volumeManager.getVolumeInfo(volume);
            return omVolumeArgs;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_VOLUME, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_VOLUME, auditMap));
            }
        }
    }

    public void deleteVolume(String volume) throws IOException {
        try {
            this.metrics.incNumVolumeDeletes();
            this.volumeManager.deleteVolume(volume);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume)));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume)), (Throwable)ex);
            throw ex;
        }
    }

    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", userName);
        try {
            this.metrics.incNumVolumeLists();
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(userName, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", null);
        try {
            this.metrics.incNumVolumeLists();
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        try {
            this.metrics.incNumBucketCreates();
            this.bucketManager.createBucket(bucketInfo);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumBucketCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap()), (Throwable)ex);
            throw ex;
        }
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int maxNumOfBuckets) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        try {
            this.metrics.incNumBucketLists();
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumBucketListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_BUCKETS, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_BUCKETS, auditMap));
            }
        }
    }

    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketInfos();
            OmBucketInfo omBucketInfo = this.bucketManager.getBucketInfo(volume, bucket);
            return omBucketInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBucketInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_BUCKET, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_BUCKET, auditMap));
            }
        }
    }

    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OpenKeySession openKeySession;
        block5: {
            boolean auditSuccess = true;
            try {
                this.metrics.incNumKeyAllocates();
                openKeySession = this.keyManager.openKey(args);
                if (!auditSuccess) break block5;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumKeyAllocateFails();
                    auditSuccess = false;
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()), (Throwable)ex);
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return openKeySession;
    }

    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("clientID", String.valueOf(clientID));
        try {
            this.metrics.incNumKeyCommits();
            this.keyManager.commitKey(args, clientID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_KEY, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumKeyCommitFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMMIT_KEY, auditMap), (Throwable)ex);
            throw ex;
        }
    }

    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("clientID", String.valueOf(clientID));
        try {
            this.metrics.incNumBlockAllocateCalls();
            OmKeyLocationInfo omKeyLocationInfo = this.keyManager.allocateBlock(args, clientID);
            return omKeyLocationInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBlockAllocateCallFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap));
            }
        }
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OmKeyInfo omKeyInfo;
        block5: {
            boolean auditSuccess = true;
            try {
                this.metrics.incNumKeyLookups();
                omKeyInfo = this.keyManager.lookupKey(args);
                if (!auditSuccess) break block5;
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumKeyLookupFails();
                    auditSuccess = false;
                    AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()), (Throwable)ex);
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return omKeyInfo;
    }

    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("toKeyName", toKeyName);
        try {
            this.metrics.incNumKeyRenames();
            this.keyManager.renameKey(args, toKeyName);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.RENAME_KEY, auditMap));
        }
        catch (IOException e) {
            this.metrics.incNumKeyRenameFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.RENAME_KEY, auditMap), (Throwable)e);
            throw e;
        }
    }

    public void deleteKey(OmKeyArgs args) throws IOException {
        try {
            this.metrics.incNumKeyDeletes();
            this.keyManager.deleteKey(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_KEY, args == null ? null : args.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumKeyDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_KEY, args == null ? null : args.toAuditMap()), (Throwable)ex);
            throw ex;
        }
    }

    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("startKey", startKey);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("keyPrefix", keyPrefix);
        try {
            this.metrics.incNumKeyLists();
            List<OmKeyInfo> list = this.keyManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_KEYS, auditMap), (Throwable)ex);
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_KEYS, auditMap));
            }
        }
    }

    public void setBucketProperty(OmBucketArgs args) throws IOException {
        try {
            this.metrics.incNumBucketUpdates();
            this.bucketManager.setBucketProperty(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumBucketUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap()), (Throwable)ex);
            throw ex;
        }
    }

    public void deleteBucket(String volume, String bucket) throws IOException {
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketDeletes();
            this.bucketManager.deleteBucket(volume, bucket);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_BUCKET, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumBucketDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_BUCKET, auditMap), (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, String> buildAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }

    private AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage(Server.getRemoteUser() == null ? null : Server.getRemoteUser().getUserName(), Server.getRemoteIp() == null ? null : Server.getRemoteIp().getHostAddress(), op.toString(), auditMap, AuditEventStatus.SUCCESS.toString());
    }

    private AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage(Server.getRemoteUser() == null ? null : Server.getRemoteUser().getUserName(), Server.getRemoteIp() == null ? null : Server.getRemoteIp().getHostAddress(), op.toString(), auditMap, AuditEventStatus.FAILURE.toString());
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.omInfoBeanName = MBeans.register((String)"OzoneManager", (String)"OzoneManagerInfo", jmxProperties, (Object)this);
    }

    private void unregisterMXBean() {
        if (this.omInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.omInfoBeanName);
            this.omInfoBeanName = null;
        }
    }

    @Override
    public String getRpcPort() {
        return "" + this.omRpcAddress.getPort();
    }

    @VisibleForTesting
    public OzoneManagerHttpServer getHttpServer() {
        return this.httpServer;
    }

    public List<ServiceInfo> getServiceList() throws IOException {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        ServiceInfo.Builder omServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(this.omRpcAddress.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(this.omRpcAddress.getPort()).build());
        if (this.httpServer.getHttpAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(this.httpServer.getHttpAddress().getPort()).build());
        }
        if (this.httpServer.getHttpsAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS).setValue(this.httpServer.getHttpsAddress().getPort()).build());
        }
        services.add(omServiceInfoBuilder.build());
        InetSocketAddress scmAddr = HddsUtils.getScmAddressForClients((Configuration)this.configuration);
        ServiceInfo.Builder scmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.SCM).setHostname(scmAddr.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(scmAddr.getPort()).build());
        services.add(scmServiceInfoBuilder.build());
        List nodes = this.scmContainerClient.queryNode(HddsProtos.NodeState.HEALTHY, HddsProtos.QueryScope.CLUSTER, "");
        for (HddsProtos.Node node : nodes) {
            HddsProtos.DatanodeDetailsProto datanode = node.getNodeID();
            ServiceInfo.Builder dnServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.DATANODE).setHostname(datanode.getHostName());
            dnServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)datanode).getPort(DatanodeDetails.Port.Name.REST).getValue().intValue()).build());
            services.add(dnServiceInfoBuilder.build());
        }
        this.metrics.incNumGetServiceLists();
        return services;
    }

    public static enum StartupOption {
        CREATEOBJECTSTORE("-createObjectStore"),
        HELP("-help"),
        REGULAR("-regular");

        private final String name;

        private StartupOption(String arg) {
            this.name = arg;
        }

        public static StartupOption parse(String value) {
            for (StartupOption option : StartupOption.values()) {
                if (!option.name.equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

