/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.BackgroundTask;
import org.apache.hadoop.utils.BackgroundTaskQueue;
import org.apache.hadoop.utils.BackgroundTaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenKeyCleanupService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(OpenKeyCleanupService.class);
    private static final int OPEN_KEY_DELETING_CORE_POOL_SIZE = 2;
    private final KeyManager keyManager;
    private final ScmBlockLocationProtocol scmClient;

    public OpenKeyCleanupService(ScmBlockLocationProtocol scmClient, KeyManager keyManager, int serviceInterval, long serviceTimeout) {
        super("OpenKeyCleanupService", (long)serviceInterval, TimeUnit.SECONDS, 2, serviceTimeout);
        this.keyManager = keyManager;
        this.scmClient = scmClient;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new OpenKeyDeletingTask());
        return queue;
    }

    private class OpenKeyDeletingTask
    implements BackgroundTask<BackgroundTaskResult> {
        private OpenKeyDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            try {
                List<BlockGroup> keyBlocksList = OpenKeyCleanupService.this.keyManager.getExpiredOpenKeys();
                if (keyBlocksList.size() > 0) {
                    int toDeleteSize = keyBlocksList.size();
                    LOG.debug("Found {} to-delete open keys in OM", (Object)toDeleteSize);
                    List results = OpenKeyCleanupService.this.scmClient.deleteKeyBlocks(keyBlocksList);
                    int deletedSize = 0;
                    for (DeleteBlockGroupResult result : results) {
                        if (result.isSuccess()) {
                            try {
                                OpenKeyCleanupService.this.keyManager.deleteExpiredOpenKey(result.getObjectKey());
                                LOG.debug("Key {} deleted from OM DB", (Object)result.getObjectKey());
                                ++deletedSize;
                            }
                            catch (IOException e) {
                                LOG.warn("Failed to delete hanging-open key {}", (Object)result.getObjectKey(), (Object)e);
                            }
                            continue;
                        }
                        LOG.warn("Deleting open Key {} failed because some of the blocks were failed to delete, failed blocks: {}", (Object)result.getObjectKey(), (Object)StringUtils.join((CharSequence)",", (Iterable)result.getFailedBlocks()));
                    }
                    LOG.info("Found {} expired open key entries, successfully cleaned up {} entries", (Object)toDeleteSize, (Object)deletedSize);
                    return results::size;
                }
                LOG.debug("No hanging open key found in OM");
            }
            catch (IOException e) {
                LOG.error("Unable to get hanging open keys, retry in next interval", (Throwable)e);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

