/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="Ozone Manager Metrics", context="dfs")
public class OMMetrics {
    private static final String SOURCE_NAME = OMMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numVolumeOps;
    @Metric
    private MutableCounterLong numBucketOps;
    @Metric
    private MutableCounterLong numKeyOps;
    @Metric
    private MutableCounterLong numVolumeCreates;
    @Metric
    private MutableCounterLong numVolumeUpdates;
    @Metric
    private MutableCounterLong numVolumeInfos;
    @Metric
    private MutableCounterLong numVolumeCheckAccesses;
    @Metric
    private MutableCounterLong numBucketCreates;
    @Metric
    private MutableCounterLong numVolumeDeletes;
    @Metric
    private MutableCounterLong numBucketInfos;
    @Metric
    private MutableCounterLong numBucketUpdates;
    @Metric
    private MutableCounterLong numBucketDeletes;
    @Metric
    private MutableCounterLong numKeyAllocate;
    @Metric
    private MutableCounterLong numKeyLookup;
    @Metric
    private MutableCounterLong numKeyRenames;
    @Metric
    private MutableCounterLong numKeyDeletes;
    @Metric
    private MutableCounterLong numBucketLists;
    @Metric
    private MutableCounterLong numKeyLists;
    @Metric
    private MutableCounterLong numVolumeLists;
    @Metric
    private MutableCounterLong numKeyCommits;
    @Metric
    private MutableCounterLong numAllocateBlockCalls;
    @Metric
    private MutableCounterLong numGetServiceLists;
    @Metric
    private MutableCounterLong numVolumeCreateFails;
    @Metric
    private MutableCounterLong numVolumeUpdateFails;
    @Metric
    private MutableCounterLong numVolumeInfoFails;
    @Metric
    private MutableCounterLong numVolumeDeleteFails;
    @Metric
    private MutableCounterLong numBucketCreateFails;
    @Metric
    private MutableCounterLong numVolumeCheckAccessFails;
    @Metric
    private MutableCounterLong numBucketInfoFails;
    @Metric
    private MutableCounterLong numBucketUpdateFails;
    @Metric
    private MutableCounterLong numBucketDeleteFails;
    @Metric
    private MutableCounterLong numKeyAllocateFails;
    @Metric
    private MutableCounterLong numKeyLookupFails;
    @Metric
    private MutableCounterLong numKeyRenameFails;
    @Metric
    private MutableCounterLong numKeyDeleteFails;
    @Metric
    private MutableCounterLong numBucketListFails;
    @Metric
    private MutableCounterLong numKeyListFails;
    @Metric
    private MutableCounterLong numVolumeListFails;
    @Metric
    private MutableCounterLong numKeyCommitFails;
    @Metric
    private MutableCounterLong numBlockAllocateCallFails;
    @Metric
    private MutableCounterLong numGetServiceListFails;

    public static OMMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OMMetrics)ms.register(SOURCE_NAME, "Ozone Manager Metrics", (Object)new OMMetrics());
    }

    public void incNumVolumeCreates() {
        this.numVolumeOps.incr();
        this.numVolumeCreates.incr();
    }

    public void incNumVolumeUpdates() {
        this.numVolumeOps.incr();
        this.numVolumeUpdates.incr();
    }

    public void incNumVolumeInfos() {
        this.numVolumeOps.incr();
        this.numVolumeInfos.incr();
    }

    public void incNumVolumeDeletes() {
        this.numVolumeOps.incr();
        this.numVolumeDeletes.incr();
    }

    public void incNumVolumeCheckAccesses() {
        this.numVolumeOps.incr();
        this.numVolumeCheckAccesses.incr();
    }

    public void incNumBucketCreates() {
        this.numBucketOps.incr();
        this.numBucketCreates.incr();
    }

    public void incNumBucketInfos() {
        this.numBucketOps.incr();
        this.numBucketInfos.incr();
    }

    public void incNumBucketUpdates() {
        this.numBucketOps.incr();
        this.numBucketUpdates.incr();
    }

    public void incNumBucketDeletes() {
        this.numBucketOps.incr();
        this.numBucketDeletes.incr();
    }

    public void incNumBucketLists() {
        this.numBucketOps.incr();
        this.numBucketLists.incr();
    }

    public void incNumKeyLists() {
        this.numKeyOps.incr();
        this.numKeyLists.incr();
    }

    public void incNumVolumeLists() {
        this.numVolumeOps.incr();
        this.numVolumeLists.incr();
    }

    public void incNumGetServiceLists() {
        this.numGetServiceLists.incr();
    }

    public void incNumVolumeCreateFails() {
        this.numVolumeCreateFails.incr();
    }

    public void incNumVolumeUpdateFails() {
        this.numVolumeUpdateFails.incr();
    }

    public void incNumVolumeInfoFails() {
        this.numVolumeInfoFails.incr();
    }

    public void incNumVolumeDeleteFails() {
        this.numVolumeDeleteFails.incr();
    }

    public void incNumVolumeCheckAccessFails() {
        this.numVolumeCheckAccessFails.incr();
    }

    public void incNumBucketCreateFails() {
        this.numBucketCreateFails.incr();
    }

    public void incNumBucketInfoFails() {
        this.numBucketInfoFails.incr();
    }

    public void incNumBucketUpdateFails() {
        this.numBucketUpdateFails.incr();
    }

    public void incNumBucketDeleteFails() {
        this.numBucketDeleteFails.incr();
    }

    public void incNumKeyAllocates() {
        this.numKeyOps.incr();
        this.numKeyAllocate.incr();
    }

    public void incNumKeyAllocateFails() {
        this.numKeyAllocateFails.incr();
    }

    public void incNumKeyLookups() {
        this.numKeyOps.incr();
        this.numKeyLookup.incr();
    }

    public void incNumKeyLookupFails() {
        this.numKeyLookupFails.incr();
    }

    public void incNumKeyRenames() {
        this.numKeyOps.incr();
        this.numKeyRenames.incr();
    }

    public void incNumKeyRenameFails() {
        this.numKeyOps.incr();
        this.numKeyRenameFails.incr();
    }

    public void incNumKeyDeleteFails() {
        this.numKeyDeleteFails.incr();
    }

    public void incNumKeyDeletes() {
        this.numKeyOps.incr();
        this.numKeyDeletes.incr();
    }

    public void incNumKeyCommits() {
        this.numKeyOps.incr();
        this.numKeyCommits.incr();
    }

    public void incNumKeyCommitFails() {
        this.numKeyCommitFails.incr();
    }

    public void incNumBlockAllocateCalls() {
        this.numAllocateBlockCalls.incr();
    }

    public void incNumBlockAllocateCallFails() {
        this.numBlockAllocateCallFails.incr();
    }

    public void incNumBucketListFails() {
        this.numBucketListFails.incr();
    }

    public void incNumKeyListFails() {
        this.numKeyListFails.incr();
    }

    public void incNumVolumeListFails() {
        this.numVolumeListFails.incr();
    }

    public void incNumGetServiceListFails() {
        this.numGetServiceListFails.incr();
    }

    @VisibleForTesting
    public long getNumVolumeCreates() {
        return this.numVolumeCreates.value();
    }

    @VisibleForTesting
    public long getNumVolumeUpdates() {
        return this.numVolumeUpdates.value();
    }

    @VisibleForTesting
    public long getNumVolumeInfos() {
        return this.numVolumeInfos.value();
    }

    @VisibleForTesting
    public long getNumVolumeDeletes() {
        return this.numVolumeDeletes.value();
    }

    @VisibleForTesting
    public long getNumVolumeCheckAccesses() {
        return this.numVolumeCheckAccesses.value();
    }

    @VisibleForTesting
    public long getNumBucketCreates() {
        return this.numBucketCreates.value();
    }

    @VisibleForTesting
    public long getNumBucketInfos() {
        return this.numBucketInfos.value();
    }

    @VisibleForTesting
    public long getNumBucketUpdates() {
        return this.numBucketUpdates.value();
    }

    @VisibleForTesting
    public long getNumBucketDeletes() {
        return this.numBucketDeletes.value();
    }

    @VisibleForTesting
    public long getNumBucketLists() {
        return this.numBucketLists.value();
    }

    @VisibleForTesting
    public long getNumVolumeLists() {
        return this.numVolumeLists.value();
    }

    @VisibleForTesting
    public long getNumKeyLists() {
        return this.numKeyLists.value();
    }

    @VisibleForTesting
    public long getNumGetServiceLists() {
        return this.numGetServiceLists.value();
    }

    @VisibleForTesting
    public long getNumVolumeCreateFails() {
        return this.numVolumeCreateFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeUpdateFails() {
        return this.numVolumeUpdateFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeInfoFails() {
        return this.numVolumeInfoFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeDeleteFails() {
        return this.numVolumeDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeCheckAccessFails() {
        return this.numVolumeCheckAccessFails.value();
    }

    @VisibleForTesting
    public long getNumBucketCreateFails() {
        return this.numBucketCreateFails.value();
    }

    @VisibleForTesting
    public long getNumBucketInfoFails() {
        return this.numBucketInfoFails.value();
    }

    @VisibleForTesting
    public long getNumBucketUpdateFails() {
        return this.numBucketUpdateFails.value();
    }

    @VisibleForTesting
    public long getNumBucketDeleteFails() {
        return this.numBucketDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumKeyAllocates() {
        return this.numKeyAllocate.value();
    }

    @VisibleForTesting
    public long getNumKeyAllocateFails() {
        return this.numKeyAllocateFails.value();
    }

    @VisibleForTesting
    public long getNumKeyLookups() {
        return this.numKeyLookup.value();
    }

    @VisibleForTesting
    public long getNumKeyLookupFails() {
        return this.numKeyLookupFails.value();
    }

    @VisibleForTesting
    public long getNumKeyRenames() {
        return this.numKeyRenames.value();
    }

    @VisibleForTesting
    public long getNumKeyRenameFails() {
        return this.numKeyRenameFails.value();
    }

    @VisibleForTesting
    public long getNumKeyDeletes() {
        return this.numKeyDeletes.value();
    }

    @VisibleForTesting
    public long getNumKeyDeletesFails() {
        return this.numKeyDeleteFails.value();
    }

    @VisibleForTesting
    public long getNumBucketListFails() {
        return this.numBucketListFails.value();
    }

    @VisibleForTesting
    public long getNumKeyListFails() {
        return this.numKeyListFails.value();
    }

    @VisibleForTesting
    public long getNumVolumeListFails() {
        return this.numVolumeListFails.value();
    }

    @VisibleForTesting
    public long getNumKeyCommits() {
        return this.numKeyCommits.value();
    }

    @VisibleForTesting
    public long getNumKeyCommitFails() {
        return this.numKeyCommitFails.value();
    }

    @VisibleForTesting
    public long getNumBlockAllocates() {
        return this.numAllocateBlockCalls.value();
    }

    @VisibleForTesting
    public long getNumBlockAllocateFails() {
        return this.numBlockAllocateCallFails.value();
    }

    @VisibleForTesting
    public long getNumGetServiceListFails() {
        return this.numGetServiceListFails.value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

