/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.BackgroundTask;
import org.apache.hadoop.utils.BackgroundTaskQueue;
import org.apache.hadoop.utils.BackgroundTaskResult;
import org.apache.hadoop.utils.db.Table;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDeletingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDeletingService.class);
    private static final int KEY_DELETING_CORE_POOL_SIZE = 2;
    private final ScmBlockLocationProtocol scmClient;
    private final KeyManager manager;
    private final int keyLimitPerTask;
    private final AtomicLong deletedKeyCount;
    private final AtomicLong runCount;

    public KeyDeletingService(ScmBlockLocationProtocol scmClient, KeyManager manager, long serviceInterval, long serviceTimeout, Configuration conf) {
        super("KeyDeletingService", serviceInterval, TimeUnit.MILLISECONDS, 2, serviceTimeout);
        this.scmClient = scmClient;
        this.manager = manager;
        this.keyLimitPerTask = conf.getInt("ozone.key.deleting.limit.per.task", 1000);
        this.deletedKeyCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
    }

    @VisibleForTesting
    public AtomicLong getRunCount() {
        return this.runCount;
    }

    @VisibleForTesting
    public AtomicLong getDeletedKeyCount() {
        return this.deletedKeyCount;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new KeyDeletingTask());
        return queue;
    }

    private class KeyDeletingTask
    implements BackgroundTask<BackgroundTaskResult> {
        private KeyDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            KeyDeletingService.this.runCount.incrementAndGet();
            try {
                List results;
                long startTime = Time.monotonicNow();
                List<BlockGroup> keyBlocksList = KeyDeletingService.this.manager.getPendingDeletionKeys(KeyDeletingService.this.keyLimitPerTask);
                if (keyBlocksList != null && keyBlocksList.size() > 0 && (results = KeyDeletingService.this.scmClient.deleteKeyBlocks(keyBlocksList)) != null) {
                    int delCount = this.deleteAllKeys(results);
                    LOG.debug("Number of keys deleted: {}, elapsed time: {}ms", (Object)delCount, (Object)(Time.monotonicNow() - startTime));
                    KeyDeletingService.this.deletedKeyCount.addAndGet(delCount);
                }
            }
            catch (IOException e) {
                LOG.error("Error while running delete keys background task. Will retry at next run.", (Throwable)e);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        private int deleteAllKeys(List<DeleteBlockGroupResult> results) throws RocksDBException, IOException {
            Table deletedTable = KeyDeletingService.this.manager.getMetadataManager().getDeletedTable();
            int deletedCount = 0;
            try (WriteBatch writeBatch = new WriteBatch();){
                for (DeleteBlockGroupResult result : results) {
                    if (!result.isSuccess()) continue;
                    writeBatch.delete(deletedTable.getHandle(), DFSUtil.string2Bytes((String)result.getObjectKey()));
                    LOG.debug("Key {} deleted from OM DB", (Object)result.getObjectKey());
                    ++deletedCount;
                }
                KeyDeletingService.this.manager.getMetadataManager().getStore().write(writeBatch);
            }
            return deletedCount;
        }
    }
}

