/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RatisHelper {
    public static final Logger LOG = LoggerFactory.getLogger(RatisHelper.class);
    public static final RaftGroupId DUMMY_GROUP_ID = RaftGroupId.valueOf((ByteString)ByteString.copyFromUtf8((String)"AOzoneRatisGroup"));
    public static final RaftGroup EMPTY_GROUP = new RaftGroup(DUMMY_GROUP_ID, Collections.emptyList());

    public static String toRaftPeerIdString(DatanodeDetails id) {
        return id.getUuidString();
    }

    public static UUID toDatanodeId(String peerIdString) {
        return UUID.fromString(peerIdString);
    }

    public static UUID toDatanodeId(RaftPeerId peerId) {
        return RatisHelper.toDatanodeId(peerId.toString());
    }

    public static UUID toDatanodeId(RaftProtos.RaftPeerProto peerId) {
        return RatisHelper.toDatanodeId(RaftPeerId.valueOf((ByteString)peerId.getId()));
    }

    public static String toRaftPeerAddressString(DatanodeDetails id) {
        return id.getIpAddress() + ":" + id.getPort(DatanodeDetails.Port.Name.RATIS).getValue();
    }

    public static RaftPeerId toRaftPeerId(DatanodeDetails id) {
        return RaftPeerId.valueOf((String)RatisHelper.toRaftPeerIdString(id));
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id) {
        return new RaftPeer(RatisHelper.toRaftPeerId(id), RatisHelper.toRaftPeerAddressString(id));
    }

    public static List<RaftPeer> toRaftPeers(Pipeline pipeline) {
        return RatisHelper.toRaftPeers(pipeline.getMachines());
    }

    public static <E extends DatanodeDetails> List<RaftPeer> toRaftPeers(List<E> datanodes) {
        return datanodes.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
    }

    public static RaftGroup emptyRaftGroup() {
        return EMPTY_GROUP;
    }

    public static RaftGroup newRaftGroup(Collection<RaftPeer> peers) {
        return peers.isEmpty() ? RatisHelper.emptyRaftGroup() : new RaftGroup(DUMMY_GROUP_ID, peers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, Collection<DatanodeDetails> peers) {
        List newPeers = peers.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
        return peers.isEmpty() ? new RaftGroup(groupId, Collections.emptyList()) : new RaftGroup(groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(Pipeline pipeline) {
        return new RaftGroup(pipeline.getId().getRaftGroupID(), RatisHelper.toRaftPeers(pipeline));
    }

    public static RaftClient newRaftClient(RpcType rpcType, Pipeline pipeline, RetryPolicy retryPolicy) {
        return RatisHelper.newRaftClient(rpcType, RatisHelper.toRaftPeerId(pipeline.getLeader()), RatisHelper.newRaftGroup(pipeline.getId().getRaftGroupID(), pipeline.getMachines()), retryPolicy);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), RatisHelper.newRaftGroup(new ArrayList<RaftPeer>(Arrays.asList(leader))), retryPolicy);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RaftGroup group, RetryPolicy retryPolicy) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), group, retryPolicy);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeerId leader, RaftGroup group, RetryPolicy retryPolicy) {
        LOG.trace("newRaftClient: {}, leader={}, group={}", new Object[]{rpcType, leader, group});
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpcType);
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)0x2000000L));
        return RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leader).setProperties(properties).setRetryPolicy(retryPolicy).build();
    }

    public static RetryPolicy createRetryPolicy(Configuration conf) {
        int maxRetryCount = conf.getInt("dfs.ratis.client.request.max.retries", 180);
        long retryInterval = conf.getTimeDuration("dfs.ratis.client.request.retry.interval", (long)OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_RETRY_INTERVAL_DEFAULT.toInt(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        long leaderElectionTimeout = conf.getTimeDuration("dfs.ratis.leader.election.minimum.timeout.duration", (long)OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.toInt(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        long clientRequestTimeout = conf.getTimeDuration("dfs.ratis.client.request.timeout.duration", (long)OzoneConfigKeys.DFS_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.toInt(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        long retryCacheTimeout = conf.getTimeDuration("dfs.ratis.server.retry-cache.timeout.duration", (long)OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.toInt(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        Preconditions.assertTrue(((long)maxRetryCount * retryInterval > 5L * leaderElectionTimeout ? 1 : 0) != 0, (Object)"Please make sure dfs.ratis.client.request.max.retries * dfs.ratis.client.request.retry.interval > 5 * dfs.ratis.leader.election.minimum.timeout.duration");
        Preconditions.assertTrue(((long)maxRetryCount * (retryInterval + clientRequestTimeout) < retryCacheTimeout ? 1 : 0) != 0, (Object)"Please make sure (dfs.ratis.client.request.max.retries * (dfs.ratis.client.request.retry.interval + dfs.ratis.client.request.timeout.duration)) < dfs.ratis.server.retry-cache.timeout.duration");
        TimeDuration sleepDuration = TimeDuration.valueOf((long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
        RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetryCount, (TimeDuration)sleepDuration);
        return retryPolicy;
    }
}

