/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import java.util.NoSuchElementException;
import org.apache.hadoop.utils.MetaStoreIterator;
import org.apache.hadoop.utils.MetadataStore;
import org.rocksdb.RocksIterator;

public class RocksDBStoreIterator
implements MetaStoreIterator<MetadataStore.KeyValue> {
    private RocksIterator rocksDBIterator;

    public RocksDBStoreIterator(RocksIterator iterator) {
        this.rocksDBIterator = iterator;
        this.rocksDBIterator.seekToFirst();
    }

    @Override
    public boolean hasNext() {
        return this.rocksDBIterator.isValid();
    }

    @Override
    public MetadataStore.KeyValue next() {
        if (this.rocksDBIterator.isValid()) {
            MetadataStore.KeyValue value = MetadataStore.KeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value());
            this.rocksDBIterator.next();
            return value;
        }
        throw new NoSuchElementException("RocksDB Store has no more elements");
    }

    @Override
    public void seekToFirst() {
        this.rocksDBIterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.rocksDBIterator.seekToLast();
    }
}

