/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.utils.BatchOperation;
import org.apache.hadoop.utils.EntryConsumer;
import org.apache.hadoop.utils.MetaStoreIterator;
import org.apache.hadoop.utils.MetadataKeyFilters;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.RocksDBStoreIterator;
import org.apache.hadoop.utils.RocksDBStoreMBean;
import org.apache.ratis.shaded.com.google.common.annotations.VisibleForTesting;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStore
implements MetadataStore {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBStore.class);
    private RocksDB db = null;
    private File dbLocation;
    private WriteOptions writeOptions;
    private Options dbOptions;
    private ObjectName statMBeanName;

    public RocksDBStore(File dbFile, Options options) throws IOException {
        Preconditions.checkNotNull((Object)dbFile, (Object)"DB file location cannot be null");
        RocksDB.loadLibrary();
        this.dbOptions = options;
        this.dbLocation = dbFile;
        this.writeOptions = new WriteOptions();
        try {
            this.db = RocksDB.open((Options)this.dbOptions, (String)this.dbLocation.getAbsolutePath());
            if (this.dbOptions.statistics() != null) {
                HashMap<String, String> jmxProperties = new HashMap<String, String>();
                jmxProperties.put("dbName", dbFile.getName());
                this.statMBeanName = MBeans.register((String)"Ozone", (String)"RocksDbStore", jmxProperties, (Object)new RocksDBStoreMBean(this.dbOptions.statistics()));
                if (this.statMBeanName == null) {
                    LOG.warn("jmx registration failed during RocksDB init, db path :{}", (Object)dbFile.getAbsolutePath());
                }
            }
        }
        catch (RocksDBException e) {
            throw new IOException("Failed init RocksDB, db path : " + dbFile.getAbsolutePath(), e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RocksDB successfully opened.");
            LOG.debug("[Option] dbLocation= {}", (Object)this.dbLocation.getAbsolutePath());
            LOG.debug("[Option] createIfMissing = {}", (Object)options.createIfMissing());
            LOG.debug("[Option] compactionPriority= {}", (Object)options.compactionStyle());
            LOG.debug("[Option] compressionType= {}", (Object)options.compressionType());
            LOG.debug("[Option] maxOpenFiles= {}", (Object)options.maxOpenFiles());
            LOG.debug("[Option] writeBufferSize= {}", (Object)options.writeBufferSize());
        }
    }

    public static IOException toIOException(String msg, RocksDBException e) {
        String statusCode = e.getStatus() == null ? "N/A" : e.getStatus().getCodeString();
        String errMessage = e.getMessage() == null ? "Unknown error" : e.getMessage();
        String output = msg + "; status : " + statusCode + "; message : " + errMessage;
        return new IOException(output, e);
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.db.put(this.writeOptions, key, value);
        }
        catch (RocksDBException e) {
            throw RocksDBStore.toIOException("Failed to put key-value to metadata store", e);
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (RocksIterator it = null;){
            it = this.db.newIterator();
            it.seekToFirst();
            boolean bl = !it.isValid();
            return bl;
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw RocksDBStore.toIOException("Failed to get the value for the given key", e);
        }
    }

    @Override
    public void delete(byte[] key) throws IOException {
        try {
            this.db.delete(key);
        }
        catch (RocksDBException e) {
            throw RocksDBStore.toIOException("Failed to delete the given key", e);
        }
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, false, filters);
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> getSequentialRangeKVs(byte[] startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, true, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<Map.Entry<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, boolean sequential, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        block19: {
            block17: {
                block18: {
                    block20: {
                        result = new ArrayList<Map.Entry<byte[], byte[]>>();
                        start = System.currentTimeMillis();
                        if (count < 0) {
                            throw new IllegalArgumentException("Invalid count given " + count + ", count must be greater than 0");
                        }
                        it = null;
                        it = this.db.newIterator();
                        if (startKey != null) break block20;
                        it.seekToFirst();
                        ** GOTO lbl32
                    }
                    if (this.get(startKey) != null) break block17;
                    var9_8 = result;
                    if (it == null) break block18;
                    it.close();
                }
                end = System.currentTimeMillis();
                timeConsumed = end - start;
                if (RocksDBStore.LOG.isDebugEnabled()) {
                    if (filters != null) {
                        for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                            scanned = filter.getKeysScannedNum();
                            hinted = filter.getKeysHintedNum();
                            if (scanned <= 0 && hinted <= 0) continue;
                            RocksDBStore.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                        }
                    }
                    RocksDBStore.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                }
                return var9_8;
            }
            try {
                it.seek(startKey);
lbl32:
                // 5 sources

                while (it.isValid() && result.size() < count) {
                    currentKey = it.key();
                    currentValue = it.value();
                    it.prev();
                    prevKey = it.isValid() != false ? it.key() : null;
                    it.seek(currentKey);
                    it.next();
                    v0 = nextKey = it.isValid() != false ? it.key() : null;
                    if (filters == null) {
                        result.add(new AbstractMap.SimpleImmutableEntry<byte[], byte[]>(currentKey, currentValue));
                        continue;
                    }
                    if (Arrays.asList(filters).stream().allMatch((Predicate<MetadataKeyFilters.MetadataKeyFilter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getRangeKVs$0(byte[] byte[] byte[] org.apache.hadoop.utils.MetadataKeyFilters$MetadataKeyFilter ), (Lorg/apache/hadoop/utils/MetadataKeyFilters$MetadataKeyFilter;)Z)((byte[])prevKey, (byte[])currentKey, (byte[])nextKey))) {
                        result.add(new AbstractMap.SimpleImmutableEntry<byte[], byte[]>(currentKey, currentValue));
                        continue;
                    }
                    if (result.size() <= 0 || !sequential) continue;
                    break;
                }
                if (it == null) break block19;
            }
            catch (Throwable var20_29) {
                if (it != null) {
                    it.close();
                }
                end = System.currentTimeMillis();
                timeConsumed = end - start;
                if (RocksDBStore.LOG.isDebugEnabled()) {
                    if (filters != null) {
                        for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                            scanned = filter.getKeysScannedNum();
                            hinted = filter.getKeysHintedNum();
                            if (scanned <= 0 && hinted <= 0) continue;
                            RocksDBStore.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                        }
                    }
                    RocksDBStore.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                }
                throw var20_29;
            }
            it.close();
        }
        end = System.currentTimeMillis();
        timeConsumed = end - start;
        if (RocksDBStore.LOG.isDebugEnabled()) {
            if (filters != null) {
                for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                    scanned = filter.getKeysScannedNum();
                    hinted = filter.getKeysHintedNum();
                    if (scanned <= 0 && hinted <= 0) continue;
                    RocksDBStore.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                }
            }
            RocksDBStore.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
        }
        return result;
    }

    @Override
    public void writeBatch(BatchOperation operation) throws IOException {
        List<BatchOperation.SingleOperation> operations = operation.getOperations();
        if (!operations.isEmpty()) {
            try (WriteBatch writeBatch = new WriteBatch();){
                block15: for (BatchOperation.SingleOperation opt : operations) {
                    switch (opt.getOpt()) {
                        case DELETE: {
                            writeBatch.delete(opt.getKey());
                            continue block15;
                        }
                        case PUT: {
                            writeBatch.put(opt.getKey(), opt.getValue());
                            continue block15;
                        }
                    }
                    throw new IllegalArgumentException("Invalid operation " + (Object)((Object)opt.getOpt()));
                }
                this.db.write(this.writeOptions, writeBatch);
            }
            catch (RocksDBException e) {
                throw RocksDBStore.toIOException("Batch write operation failed", e);
            }
        }
    }

    @Override
    public void compactDB() throws IOException {
        if (this.db != null) {
            try {
                this.db.compactRange();
            }
            catch (RocksDBException e) {
                throw RocksDBStore.toIOException("Failed to compact db", e);
            }
        }
    }

    private void deleteQuietly(File fileOrDir) {
        if (fileOrDir != null && fileOrDir.exists()) {
            try {
                FileUtils.forceDelete((File)fileOrDir);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete dir {}", (Object)fileOrDir.getAbsolutePath(), (Object)e);
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        this.close();
        this.deleteQuietly(this.dbLocation);
        this.deleteQuietly(new File(this.dbOptions.dbLogDir()));
        this.deleteQuietly(new File(this.dbOptions.walDir()));
        List dbPaths = this.dbOptions.dbPaths();
        if (dbPaths != null) {
            dbPaths.forEach(dbPath -> this.deleteQuietly(new File(dbPath.toString())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutablePair<byte[], byte[]> peekAround(int offset, byte[] from) throws IOException, IllegalArgumentException {
        try (RocksIterator it = null;){
            it = this.db.newIterator();
            if (from == null) {
                it.seekToFirst();
            } else {
                it.seek(from);
            }
            if (!it.isValid()) {
                ImmutablePair<byte[], byte[]> immutablePair = null;
                return immutablePair;
            }
            switch (offset) {
                case 0: {
                    break;
                }
                case 1: {
                    it.next();
                    break;
                }
                case -1: {
                    it.prev();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Position can only be -1, 0 or 1, but found " + offset);
                }
            }
            ImmutablePair immutablePair = it.isValid() ? new ImmutablePair((Object)it.key(), (Object)it.value()) : null;
            return immutablePair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterate(byte[] from, EntryConsumer consumer) throws IOException {
        try (RocksIterator it = null;){
            it = this.db.newIterator();
            if (from != null) {
                it.seek(from);
            } else {
                it.seekToFirst();
            }
            while (it.isValid()) {
                if (!consumer.consume(it.key(), it.value())) {
                    break;
                }
                it.next();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.statMBeanName != null) {
            MBeans.unregister((ObjectName)this.statMBeanName);
            this.statMBeanName = null;
        }
        if (this.db != null) {
            this.db.close();
        }
    }

    @VisibleForTesting
    protected ObjectName getStatMBeanName() {
        return this.statMBeanName;
    }

    @Override
    public MetaStoreIterator<MetadataStore.KeyValue> iterator() {
        return new RocksDBStoreIterator(this.db.newIterator());
    }

    private static /* synthetic */ boolean lambda$getRangeKVs$0(byte[] prevKey, byte[] currentKey, byte[] nextKey, MetadataKeyFilters.MetadataKeyFilter entry) {
        return entry.filterKey(prevKey, currentKey, nextKey);
    }
}

