/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;

@InterfaceAudience.Private
public final class ScmBlockLocationProtocolServerSideTranslatorPB
implements ScmBlockLocationProtocolPB {
    private final ScmBlockLocationProtocol impl;

    public ScmBlockLocationProtocolServerSideTranslatorPB(ScmBlockLocationProtocol impl) throws IOException {
        this.impl = impl;
    }

    @Override
    public ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto allocateScmBlock(RpcController controller, ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto request) throws ServiceException {
        try {
            AllocatedBlock allocatedBlock = this.impl.allocateBlock(request.getSize(), request.getType(), request.getFactor(), request.getOwner());
            if (allocatedBlock != null) {
                return ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.newBuilder().setBlockID(allocatedBlock.getBlockID().getProtobuf()).setPipeline(allocatedBlock.getPipeline().getProtobufMessage()).setCreateContainer(allocatedBlock.getCreateContainer()).setErrorCode(ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Error.success).build();
            }
            return ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.newBuilder().setErrorCode(ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Error.unknownFailure).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto deleteScmKeyBlocks(RpcController controller, ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto req) throws ServiceException {
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto.Builder resp = ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto.newBuilder();
        try {
            List<BlockGroup> infoList = req.getKeyBlocksList().stream().map(BlockGroup::getFromProto).collect(Collectors.toList());
            List<DeleteBlockGroupResult> results = this.impl.deleteKeyBlocks(infoList);
            for (DeleteBlockGroupResult result : results) {
                ScmBlockLocationProtocolProtos.DeleteKeyBlocksResultProto.Builder deleteResult = ScmBlockLocationProtocolProtos.DeleteKeyBlocksResultProto.newBuilder().setObjectKey(result.getObjectKey()).addAllBlockResults(result.getBlockResultProtoList());
                resp.addResults(deleteResult.build());
            }
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
        return resp.build();
    }

    @Override
    public HddsProtos.GetScmInfoRespsonseProto getScmInfo(RpcController controller, HddsProtos.GetScmInfoRequestProto req) throws ServiceException {
        ScmInfo scmInfo;
        try {
            scmInfo = this.impl.getScmInfo();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
        return HddsProtos.GetScmInfoRespsonseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).build();
    }
}

