/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.lock.ActiveLock;
import org.apache.hadoop.ozone.lock.PooledLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final Map<T, ActiveLock> activeLocks = new ConcurrentHashMap<T, ActiveLock>();
    private final GenericObjectPool<ActiveLock> lockPool = new GenericObjectPool((PooledObjectFactory)new PooledLockFactory());

    public LockManager(Configuration conf) {
        int maxPoolSize = conf.getInt("hdds.lock.max.concurrency", 100);
        this.lockPool.setMaxTotal(maxPoolSize);
    }

    public void lock(T resource) {
        this.activeLocks.compute(resource, (k, v) -> {
            ActiveLock lock;
            try {
                lock = v == null ? (ActiveLock)this.lockPool.borrowObject() : v;
                lock.incrementActiveCount();
            }
            catch (Exception ex) {
                LOG.error("Unable to obtain lock.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            return lock;
        }).lock();
    }

    public void unlock(T resource) {
        ActiveLock lock = this.activeLocks.get(resource);
        if (lock == null) {
            LOG.warn("Trying to release the lock on {}, which was never acquired.", resource);
            return;
        }
        lock.unlock();
        this.activeLocks.computeIfPresent(resource, (k, v) -> {
            v.decrementActiveCount();
            if (v.getActiveLockCount() != 0) {
                return v;
            }
            this.lockPool.returnObject(v);
            return null;
        });
    }
}

