/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lock;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ActiveLock {
    private Lock lock = new ReentrantLock();
    private AtomicInteger count = new AtomicInteger(0);

    private ActiveLock() {
    }

    public static ActiveLock newInstance() {
        return new ActiveLock();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    void incrementActiveCount() {
        this.count.incrementAndGet();
    }

    void decrementActiveCount() {
        this.count.decrementAndGet();
    }

    int getActiveLockCount() {
        return this.count.get();
    }

    void resetCounter() {
        this.count.set(0);
    }

    public String toString() {
        return this.lock.toString();
    }
}

