/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.ozone.lease.Lease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseCallbackExecutor<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Lease.class);
    private final T resource;
    private final List<Callable<Void>> callbacks;

    public LeaseCallbackExecutor(T resource, List<Callable<Void>> callbacks) {
        this.resource = resource;
        this.callbacks = callbacks;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing callbacks for lease on {}", this.resource);
        }
        for (Callable<Void> callback : this.callbacks) {
            try {
                callback.call();
            }
            catch (Exception e) {
                LOG.warn("Exception while executing callback for lease on {}", this.resource, (Object)e);
            }
        }
    }
}

