/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;

public class KeyData {
    private final BlockID blockID;
    private final Map<String, String> metadata;
    private Object chunkList;
    private long size;

    public KeyData(BlockID blockID) {
        this.blockID = blockID;
        this.metadata = new TreeMap<String, String>();
        this.size = 0L;
    }

    public static KeyData getFromProtoBuf(ContainerProtos.KeyData data) throws IOException {
        KeyData keyData = new KeyData(BlockID.getFromProtobuf(data.getBlockID()));
        for (int x = 0; x < data.getMetadataCount(); ++x) {
            keyData.addMetadata(data.getMetadata(x).getKey(), data.getMetadata(x).getValue());
        }
        keyData.setChunks(data.getChunksList());
        if (data.hasSize()) {
            Preconditions.checkArgument((data.getSize() == keyData.getSize() ? 1 : 0) != 0);
        }
        return keyData;
    }

    public ContainerProtos.KeyData getProtoBufMessage() {
        ContainerProtos.KeyData.Builder builder = ContainerProtos.KeyData.newBuilder();
        builder.setBlockID(this.blockID.getDatanodeBlockIDProtobuf());
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            ContainerProtos.KeyValue.Builder keyValBuilder = ContainerProtos.KeyValue.newBuilder();
            builder.addMetadata(keyValBuilder.setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        builder.addAllChunks(this.getChunks());
        builder.setSize(this.size);
        return builder.build();
    }

    public synchronized void addMetadata(String key, String value) throws IOException {
        if (this.metadata.containsKey(key)) {
            throw new IOException("This key already exists. Key " + key);
        }
        this.metadata.put(key, value);
    }

    public synchronized Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public synchronized String getValue(String key) {
        return this.metadata.get(key);
    }

    public synchronized void deleteKey(String key) {
        this.metadata.remove(key);
    }

    private List<ContainerProtos.ChunkInfo> castChunkList() {
        return (List)this.chunkList;
    }

    public List<ContainerProtos.ChunkInfo> getChunks() {
        return this.chunkList == null ? Collections.emptyList() : (this.chunkList instanceof ContainerProtos.ChunkInfo ? Collections.singletonList((ContainerProtos.ChunkInfo)this.chunkList) : Collections.unmodifiableList(this.castChunkList()));
    }

    public void addChunk(ContainerProtos.ChunkInfo chunkInfo) {
        if (this.chunkList == null) {
            this.chunkList = chunkInfo;
        } else {
            List<ContainerProtos.ChunkInfo> list;
            if (this.chunkList instanceof ContainerProtos.ChunkInfo) {
                list = new ArrayList<ContainerProtos.ChunkInfo>(2);
                list.add((ContainerProtos.ChunkInfo)this.chunkList);
                this.chunkList = list;
            } else {
                list = this.castChunkList();
            }
            list.add(chunkInfo);
        }
        this.size += chunkInfo.getLen();
    }

    public boolean removeChunk(ContainerProtos.ChunkInfo chunkInfo) {
        boolean removed;
        if (this.chunkList instanceof List) {
            List<ContainerProtos.ChunkInfo> list = this.castChunkList();
            removed = list.remove(chunkInfo);
            if (list.size() == 1) {
                this.chunkList = list.get(0);
            }
        } else if (chunkInfo.equals(this.chunkList)) {
            this.chunkList = null;
            removed = true;
        } else {
            removed = false;
        }
        if (removed) {
            this.size -= chunkInfo.getLen();
        }
        return removed;
    }

    public long getContainerID() {
        return this.blockID.getContainerID();
    }

    public long getLocalID() {
        return this.blockID.getLocalID();
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public void setChunks(List<ContainerProtos.ChunkInfo> chunks) {
        if (chunks == null) {
            this.chunkList = null;
            this.size = 0L;
        } else {
            int n = chunks.size();
            this.chunkList = n == 0 ? null : (n == 1 ? chunks.get(0) : chunks);
            this.size = chunks.parallelStream().mapToLong(ContainerProtos.ChunkInfo::getLen).sum();
        }
    }

    public long getSize() {
        return this.size;
    }
}

