/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMarker;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class AuditLogger {
    private ExtendedLogger logger;
    private static final String FQCN = AuditLogger.class.getName();
    private static final Marker WRITE_MARKER = AuditMarker.WRITE.getMarker();
    private static final Marker READ_MARKER = AuditMarker.READ.getMarker();

    public AuditLogger(AuditLoggerType type) {
        this.initializeLogger(type);
    }

    private void initializeLogger(AuditLoggerType loggerType) {
        this.logger = LogManager.getContext((boolean)false).getLogger(loggerType.getType());
    }

    @VisibleForTesting
    public ExtendedLogger getLogger() {
        return this.logger;
    }

    public void logWriteSuccess(AuditMessage msg) {
        this.logWriteSuccess(Level.INFO, msg);
    }

    public void logWriteSuccess(Level level, AuditMessage msg) {
        this.logger.logIfEnabled(FQCN, level, WRITE_MARKER, (Message)msg, null);
    }

    public void logWriteFailure(AuditMessage msg) {
        this.logWriteFailure(Level.ERROR, msg);
    }

    public void logWriteFailure(Level level, AuditMessage msg) {
        this.logWriteFailure(level, msg, null);
    }

    public void logWriteFailure(AuditMessage msg, Throwable exception) {
        this.logWriteFailure(Level.ERROR, msg, exception);
    }

    public void logWriteFailure(Level level, AuditMessage msg, Throwable exception) {
        this.logger.logIfEnabled(FQCN, level, WRITE_MARKER, (Message)msg, exception);
    }

    public void logReadSuccess(AuditMessage msg) {
        this.logReadSuccess(Level.INFO, msg);
    }

    public void logReadSuccess(Level level, AuditMessage msg) {
        this.logger.logIfEnabled(FQCN, level, READ_MARKER, (Message)msg, null);
    }

    public void logReadFailure(AuditMessage msg) {
        this.logReadFailure(Level.ERROR, msg);
    }

    public void logReadFailure(Level level, AuditMessage msg) {
        this.logReadFailure(level, msg, null);
    }

    public void logReadFailure(AuditMessage msg, Throwable exception) {
        this.logReadFailure(Level.ERROR, msg, exception);
    }

    public void logReadFailure(Level level, AuditMessage msg, Throwable exception) {
        this.logger.logIfEnabled(FQCN, level, READ_MARKER, (Message)msg, exception);
    }
}

