/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;

@InterfaceAudience.Private
public final class ScmBlockLocationProtocolClientSideTranslatorPB
implements ScmBlockLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final ScmBlockLocationProtocolPB rpcProxy;

    public ScmBlockLocationProtocolClientSideTranslatorPB(ScmBlockLocationProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public AllocatedBlock allocateBlock(long size, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto response;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"block size must be greater than 0");
        ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto request = ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto.newBuilder().setSize(size).setType(type).setFactor(factor).setOwner(owner).build();
        try {
            response = this.rpcProxy.allocateScmBlock(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        if (response.getErrorCode() != ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Error.success) {
            throw new IOException(response.hasErrorMessage() ? response.getErrorMessage() : "Allocate block failed.");
        }
        AllocatedBlock.Builder builder = new AllocatedBlock.Builder().setBlockID(BlockID.getFromProtobuf(response.getBlockID())).setPipeline(Pipeline.getFromProtoBuf(response.getPipeline())).setShouldCreateContainer(response.getCreateContainer());
        return builder.build();
    }

    @Override
    public List<DeleteBlockGroupResult> deleteKeyBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto resp;
        List keyBlocksProto = keyBlocksInfoList.stream().map(BlockGroup::getProto).collect(Collectors.toList());
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto request = ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto.newBuilder().addAllKeyBlocks(keyBlocksProto).build();
        try {
            resp = this.rpcProxy.deleteScmKeyBlocks(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        ArrayList<DeleteBlockGroupResult> results = new ArrayList<DeleteBlockGroupResult>(resp.getResultsCount());
        results.addAll(resp.getResultsList().stream().map(result -> new DeleteBlockGroupResult(result.getObjectKey(), DeleteBlockGroupResult.convertBlockResultProto(result.getBlockResultsList()))).collect(Collectors.toList()));
        return results;
    }

    @Override
    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRespsonseProto resp;
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.getDefaultInstance();
        try {
            resp = this.rpcProxy.getScmInfo(NULL_RPC_CONTROLLER, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId());
        return builder.build();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }
}

