/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.ratis.protocol.RaftGroupId;

public final class PipelineID
implements Comparable<PipelineID> {
    private UUID id;
    private RaftGroupId groupId;

    private PipelineID(UUID id) {
        this.id = id;
        this.groupId = RaftGroupId.valueOf((UUID)id);
    }

    public static PipelineID randomId() {
        return new PipelineID(UUID.randomUUID());
    }

    public static PipelineID valueOf(UUID id) {
        return new PipelineID(id);
    }

    public static PipelineID valueOf(RaftGroupId groupId) {
        return PipelineID.valueOf(groupId.getUuid());
    }

    public RaftGroupId getRaftGroupID() {
        return this.groupId;
    }

    public UUID getId() {
        return this.id;
    }

    public HddsProtos.PipelineID getProtobuf() {
        return HddsProtos.PipelineID.newBuilder().setId(this.id.toString()).build();
    }

    public static PipelineID getFromProtobuf(HddsProtos.PipelineID protos) {
        return new PipelineID(UUID.fromString(protos.getId()));
    }

    public String toString() {
        return "pipelineId=" + this.id;
    }

    @Override
    public int compareTo(PipelineID o) {
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineID that = (PipelineID)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

