/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;

public class Pipeline {
    static final String PIPELINE_INFO = "PIPELINE_INFO_FILTER";
    private static final ObjectWriter WRITER;
    @JsonIgnore
    private String leaderID;
    @JsonIgnore
    private Map<String, DatanodeDetails> datanodes;
    private HddsProtos.LifeCycleState lifeCycleState;
    private HddsProtos.ReplicationType type;
    private HddsProtos.ReplicationFactor factor;
    private PipelineID id;

    public Pipeline(String leaderID, HddsProtos.LifeCycleState lifeCycleState, HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor replicationFactor, PipelineID id) {
        this.leaderID = leaderID;
        this.lifeCycleState = lifeCycleState;
        this.type = replicationType;
        this.factor = replicationFactor;
        this.id = id;
        this.datanodes = new ConcurrentHashMap<String, DatanodeDetails>();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pipeline that = (Pipeline)o;
        return this.id.equals(that.id) && this.factor.equals((Object)that.factor) && this.type.equals((Object)that.type) && this.lifeCycleState.equals((Object)that.lifeCycleState) && this.leaderID.equals(that.leaderID);
    }

    public static Pipeline getFromProtoBuf(HddsProtos.Pipeline pipelineProto) {
        Preconditions.checkNotNull((Object)pipelineProto);
        Pipeline pipeline = new Pipeline(pipelineProto.getLeaderID(), pipelineProto.getState(), pipelineProto.getType(), pipelineProto.getFactor(), PipelineID.getFromProtobuf(pipelineProto.getId()));
        for (HddsProtos.DatanodeDetailsProto dataID : pipelineProto.getMembersList()) {
            pipeline.addMember(DatanodeDetails.getFromProtoBuf(dataID));
        }
        return pipeline;
    }

    public HddsProtos.ReplicationFactor getFactor() {
        return this.factor;
    }

    @JsonIgnore
    public DatanodeDetails getLeader() {
        return this.getDatanodes().get(this.leaderID);
    }

    public boolean addMember(DatanodeDetails datanodeDetails) {
        return this.datanodes.put(datanodeDetails.getUuid().toString(), datanodeDetails) == null;
    }

    public void resetPipeline() {
        this.datanodes.clear();
    }

    public Map<String, DatanodeDetails> getDatanodes() {
        return this.datanodes;
    }

    public String getLeaderHost() {
        return this.getDatanodes().get(this.leaderID).getHostName();
    }

    public String getLeaderID() {
        return this.leaderID;
    }

    @JsonIgnore
    public List<DatanodeDetails> getMachines() {
        return new ArrayList<DatanodeDetails>(this.getDatanodes().values());
    }

    public List<String> getDatanodeHosts() {
        ArrayList<String> dataHosts = new ArrayList<String>();
        for (DatanodeDetails datanode : this.getDatanodes().values()) {
            dataHosts.add(datanode.getHostName());
        }
        return dataHosts;
    }

    @JsonIgnore
    public HddsProtos.Pipeline getProtobufMessage() {
        HddsProtos.Pipeline.Builder builder = HddsProtos.Pipeline.newBuilder();
        for (DatanodeDetails datanode : this.datanodes.values()) {
            builder.addMembers(datanode.getProtoBufMessage());
        }
        builder.setLeaderID(this.leaderID);
        if (this.lifeCycleState != null) {
            builder.setState(this.lifeCycleState);
        }
        if (this.type != null) {
            builder.setType(this.type);
        }
        if (this.factor != null) {
            builder.setFactor(this.factor);
        }
        if (this.id != null) {
            builder.setId(this.id.getProtobuf());
        }
        return builder.build();
    }

    public HddsProtos.LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public void setLifeCycleState(HddsProtos.LifeCycleState nextState) {
        this.lifeCycleState = nextState;
    }

    public PipelineID getId() {
        return this.id;
    }

    public HddsProtos.ReplicationType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append("[");
        this.getDatanodes().keySet().forEach(node -> b.append(node.endsWith(this.getLeaderID()) ? "*" + this.id : this.id));
        b.append(" id:").append(this.id);
        if (this.getType() != null) {
            b.append(" type:").append(this.getType().toString());
        }
        if (this.getFactor() != null) {
            b.append(" factor:").append(this.getFactor().toString());
        }
        if (this.getLifeCycleState() != null) {
            b.append(" State:").append(this.getLifeCycleState().toString());
        }
        return b.toString();
    }

    public String toJsonString() throws IOException {
        return WRITER.writeValueAsString((Object)this);
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        String[] ignorableFieldNames = new String[]{"leaderID", "datanodes"};
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter(PIPELINE_INFO, SimpleBeanPropertyFilter.serializeAllExcept((String[])ignorableFieldNames));
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.addMixIn(Object.class, MixIn.class);
        WRITER = mapper.writer((FilterProvider)filters);
    }

    @JsonFilter(value="PIPELINE_INFO_FILTER")
    class MixIn {
        MixIn() {
        }
    }
}

