/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.util.Comparator;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;

public class ContainerWithPipeline
implements Comparator<ContainerWithPipeline>,
Comparable<ContainerWithPipeline> {
    private final ContainerInfo containerInfo;
    private final Pipeline pipeline;

    public ContainerWithPipeline(ContainerInfo containerInfo, Pipeline pipeline) {
        this.containerInfo = containerInfo;
        this.pipeline = pipeline;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public static ContainerWithPipeline fromProtobuf(HddsProtos.ContainerWithPipeline allocatedContainer) {
        return new ContainerWithPipeline(ContainerInfo.fromProtobuf(allocatedContainer.getContainerInfo()), Pipeline.getFromProtoBuf(allocatedContainer.getPipeline()));
    }

    public HddsProtos.ContainerWithPipeline getProtobuf() {
        HddsProtos.ContainerWithPipeline.Builder builder = HddsProtos.ContainerWithPipeline.newBuilder();
        builder.setContainerInfo(this.getContainerInfo().getProtobuf()).setPipeline(this.getPipeline().getProtobufMessage());
        return builder.build();
    }

    public String toString() {
        return this.containerInfo.toString() + " | " + this.pipeline.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerWithPipeline that = (ContainerWithPipeline)o;
        return new EqualsBuilder().append((Object)this.getContainerInfo(), (Object)that.getContainerInfo()).append((Object)this.getPipeline(), (Object)that.getPipeline()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 811).append((Object)this.getContainerInfo()).append((Object)this.getPipeline()).toHashCode();
    }

    @Override
    public int compare(ContainerWithPipeline o1, ContainerWithPipeline o2) {
        return o1.getContainerInfo().compareTo(o2.getContainerInfo());
    }

    @Override
    public int compareTo(ContainerWithPipeline o) {
        return this.compare(this, o);
    }
}

