/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;

public final class AllocatedBlock {
    private Pipeline pipeline;
    private BlockID blockID;
    private boolean shouldCreateContainer;

    private AllocatedBlock(Pipeline pipeline, BlockID blockID, boolean shouldCreateContainer) {
        this.pipeline = pipeline;
        this.blockID = blockID;
        this.shouldCreateContainer = shouldCreateContainer;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public boolean getCreateContainer() {
        return this.shouldCreateContainer;
    }

    public static class Builder {
        private Pipeline pipeline;
        private BlockID blockID;
        private boolean shouldCreateContainer;

        public Builder setPipeline(Pipeline p) {
            this.pipeline = p;
            return this;
        }

        public Builder setBlockID(BlockID blockId) {
            this.blockID = blockId;
            return this;
        }

        public Builder setShouldCreateContainer(boolean shouldCreate) {
            this.shouldCreateContainer = shouldCreate;
            return this;
        }

        public AllocatedBlock build() {
            return new AllocatedBlock(this.pipeline, this.blockID, this.shouldCreateContainer);
        }
    }
}

