/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ContainerID
implements Comparable {
    private final long id;

    public ContainerID(long id) {
        Preconditions.checkState((id > 0L ? 1 : 0) != 0, (Object)("Container ID should be a positive long. " + id));
        this.id = id;
    }

    public static ContainerID valueof(long containerID) {
        return new ContainerID(containerID);
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerID that = (ContainerID)o;
        return new EqualsBuilder().append(this.getId(), that.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 71).append(this.getId()).toHashCode();
    }

    public int compareTo(Object o) {
        Preconditions.checkNotNull((Object)o);
        if (this.getClass() != o.getClass()) {
            throw new ClassCastException("ContainerID class expected. found:" + o.getClass().toString());
        }
        ContainerID that = (ContainerID)o;
        return new CompareToBuilder().append(this.getId(), that.getId()).build();
    }

    public String toString() {
        return "id=" + this.id;
    }
}

