/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.Pipeline;

public abstract class XceiverClientSpi
implements Closeable {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private boolean isEvicted = false;

    XceiverClientSpi() {
    }

    void incrementReference() {
        this.referenceCount.incrementAndGet();
    }

    void decrementReference() {
        this.referenceCount.decrementAndGet();
        this.cleanup();
    }

    void setEvicted() {
        this.isEvicted = true;
        this.cleanup();
    }

    private void cleanup() {
        if (this.referenceCount.get() == 0 && this.isEvicted) {
            this.close();
        }
    }

    @VisibleForTesting
    public int getRefcount() {
        return this.referenceCount.get();
    }

    public abstract void connect() throws Exception;

    @Override
    public abstract void close();

    public abstract Pipeline getPipeline();

    public abstract ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto var1) throws IOException;

    public abstract CompletableFuture<ContainerProtos.ContainerCommandResponseProto> sendCommandAsync(ContainerProtos.ContainerCommandRequestProto var1) throws IOException, ExecutionException, InterruptedException;

    public abstract void createPipeline() throws IOException;

    public abstract void destroyPipeline() throws IOException;

    public abstract HddsProtos.ReplicationType getPipelineType();
}

