/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDetails
implements Comparable<DatanodeDetails> {
    private final UUID uuid;
    private String ipAddress;
    private String hostName;
    private List<Port> ports;

    private DatanodeDetails(String uuid, String ipAddress, String hostName, List<Port> ports) {
        this.uuid = UUID.fromString(uuid);
        this.ipAddress = ipAddress;
        this.hostName = hostName;
        this.ports = ports;
    }

    protected DatanodeDetails(DatanodeDetails datanodeDetails) {
        this.uuid = datanodeDetails.uuid;
        this.ipAddress = datanodeDetails.ipAddress;
        this.hostName = datanodeDetails.hostName;
        this.ports = datanodeDetails.ports;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUuidString() {
        return this.uuid.toString();
    }

    public void setIpAddress(String ip) {
        this.ipAddress = ip;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(Port port) {
        this.ports.remove(port);
        this.ports.add(port);
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public Port getPort(Port.Name name) {
        for (Port port : this.ports) {
            if (!port.getName().equals((Object)name)) continue;
            return port;
        }
        return null;
    }

    public static DatanodeDetails getFromProtoBuf(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        Builder builder = DatanodeDetails.newBuilder();
        builder.setUuid(datanodeDetailsProto.getUuid());
        if (datanodeDetailsProto.hasIpAddress()) {
            builder.setIpAddress(datanodeDetailsProto.getIpAddress());
        }
        if (datanodeDetailsProto.hasHostName()) {
            builder.setHostName(datanodeDetailsProto.getHostName());
        }
        for (HddsProtos.Port port : datanodeDetailsProto.getPortsList()) {
            builder.addPort(DatanodeDetails.newPort(Port.Name.valueOf(port.getName().toUpperCase()), port.getValue()));
        }
        return builder.build();
    }

    public HddsProtos.DatanodeDetailsProto getProtoBufMessage() {
        HddsProtos.DatanodeDetailsProto.Builder builder = HddsProtos.DatanodeDetailsProto.newBuilder().setUuid(this.getUuidString());
        if (this.ipAddress != null) {
            builder.setIpAddress(this.ipAddress);
        }
        if (this.hostName != null) {
            builder.setHostName(this.hostName);
        }
        for (Port port : this.ports) {
            builder.addPorts(HddsProtos.Port.newBuilder().setName(port.getName().toString()).setValue(port.getValue()).build());
        }
        return builder.build();
    }

    public String toString() {
        return this.uuid.toString() + "{ip: " + this.ipAddress + ", host: " + this.hostName + "}";
    }

    @Override
    public int compareTo(DatanodeDetails that) {
        return this.getUuid().compareTo(that.getUuid());
    }

    public boolean equals(Object obj) {
        return obj instanceof DatanodeDetails && this.uuid.equals(((DatanodeDetails)obj).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Port newPort(Port.Name name, Integer value) {
        return new Port(name, value);
    }

    public static final class Port {
        private Name name;
        private Integer value;

        private Port(Name name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public Name getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof Port) {
                return this.name.equals((Object)((Port)anObject).name);
            }
            return false;
        }

        public static enum Name {
            STANDALONE,
            RATIS,
            REST;

        }
    }

    public static final class Builder {
        private String id;
        private String ipAddress;
        private String hostName;
        private List<Port> ports = new ArrayList<Port>();

        private Builder() {
        }

        public Builder setUuid(String uuid) {
            this.id = uuid;
            return this;
        }

        public Builder setIpAddress(String ip) {
            this.ipAddress = ip;
            return this;
        }

        public Builder setHostName(String host) {
            this.hostName = host;
            return this;
        }

        public Builder addPort(Port port) {
            this.ports.add(port);
            return this;
        }

        public DatanodeDetails build() {
            Preconditions.checkNotNull((Object)this.id);
            return new DatanodeDetails(this.id, this.ipAddress, this.hostName, this.ports);
        }
    }
}

