/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.http.HttpServer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HddsConfServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final String FORMAT_JSON = "json";
    protected static final String FORMAT_XML = "xml";
    private static final String COMMAND = "cmd";
    private static final OzoneConfiguration OZONE_CONFIG = new OzoneConfiguration();
    private static final transient Logger LOG = LoggerFactory.getLogger(HddsConfServlet.class);

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hadoop.conf");
        assert (conf != null);
        return conf;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer2.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        String format = HddsConfServlet.parseAcceptHeader(request);
        if (FORMAT_XML.equals(format)) {
            response.setContentType("text/xml; charset=utf-8");
        } else if (FORMAT_JSON.equals(format)) {
            response.setContentType("application/json; charset=utf-8");
        }
        String name = request.getParameter("name");
        PrintWriter out = response.getWriter();
        String cmd = request.getParameter(COMMAND);
        this.processCommand(cmd, format, request, response, out, name);
        ((Writer)out).close();
    }

    private void processCommand(String cmd, String format, HttpServletRequest request, HttpServletResponse response, Writer out, String name) throws IOException {
        try {
            if (cmd == null) {
                if (FORMAT_XML.equals(format)) {
                    response.setContentType("text/xml; charset=utf-8");
                } else if (FORMAT_JSON.equals(format)) {
                    response.setContentType("application/json; charset=utf-8");
                }
                HddsConfServlet.writeResponse(this.getConfFromContext(), out, format, name);
            } else {
                this.processConfigTagRequest(request, out);
            }
        }
        catch (BadFormatException bfe) {
            response.sendError(400, bfe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            response.sendError(404, iae.getMessage());
        }
    }

    @VisibleForTesting
    static String parseAcceptHeader(HttpServletRequest request) {
        String format = request.getHeader("Accept");
        return format != null && format.contains(FORMAT_JSON) ? FORMAT_JSON : FORMAT_XML;
    }

    static void writeResponse(Configuration conf, Writer out, String format, String propertyName) throws IOException, IllegalArgumentException, BadFormatException {
        if (FORMAT_JSON.equals(format)) {
            Configuration.dumpConfiguration((Configuration)conf, (String)propertyName, (Writer)out);
        } else if (FORMAT_XML.equals(format)) {
            conf.writeXml(propertyName, out);
        } else {
            throw new BadFormatException("Bad format: " + format);
        }
    }

    private void processConfigTagRequest(HttpServletRequest request, Writer out) throws IOException {
        String cmd = request.getParameter(COMMAND);
        Gson gson = new Gson();
        Configuration config = HddsConfServlet.getOzoneConfig();
        switch (cmd) {
            case "getOzoneTags": {
                out.write(gson.toJson((Object)config.get("ozone.tags.system").split(",")));
                break;
            }
            case "getPropertyByTag": {
                String tags = request.getParameter("tags");
                HashMap<String, Properties> propMap = new HashMap<String, Properties>();
                for (String tag : tags.split(",")) {
                    if (config.isPropertyTag(tag)) {
                        Properties properties = config.getAllPropertiesByTag(tag);
                        propMap.put(tag, properties);
                        continue;
                    }
                    LOG.debug("Not a valid tag" + tag);
                }
                out.write(gson.toJsonTree(propMap).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException(cmd + " is not a valid command.");
            }
        }
    }

    private static Configuration getOzoneConfig() {
        return OZONE_CONFIG;
    }

    public static class BadFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadFormatException(String msg) {
            super(msg);
        }
    }
}

