/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.MissingSubcommandException;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import picocli.CommandLine;

public class GenericCli
implements Callable<Void>,
GenericParentCommand {
    @CommandLine.Option(names={"--verbose"}, description={"More verbose output. Show the stack trace of the errors."})
    private boolean verbose;
    @CommandLine.Option(names={"-D", "--set"})
    private Map<String, String> configurationOverrides = new HashMap<String, String>();
    private final CommandLine cmd = new CommandLine((Object)this);

    public void run(String[] argv) {
        try {
            this.execute(argv);
        }
        catch (CommandLine.ExecutionException ex) {
            this.printError(ex.getCause());
            System.exit(-1);
        }
    }

    @VisibleForTesting
    public void execute(String[] argv) {
        this.cmd.parseWithHandler((CommandLine.IParseResultHandler2)new CommandLine.RunLast(), argv);
    }

    private void printError(Throwable error) {
        if (this.verbose) {
            error.printStackTrace(System.err);
        } else {
            System.err.println(error.getMessage().split("\n")[0]);
        }
        if (error instanceof MissingSubcommandException) {
            System.err.println(((MissingSubcommandException)error).getUsage());
        }
    }

    @Override
    public Void call() throws Exception {
        throw new MissingSubcommandException(this.cmd.getUsageMessage());
    }

    public OzoneConfiguration createOzoneConfiguration() {
        OzoneConfiguration ozoneConf = new OzoneConfiguration();
        if (this.configurationOverrides != null) {
            for (Map.Entry<String, String> entry : this.configurationOverrides.entrySet()) {
                ozoneConf.set(entry.getKey(), this.configurationOverrides.get(entry.getValue()));
            }
        }
        return ozoneConf;
    }

    @VisibleForTesting
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }
}

