/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HddsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HddsUtils.class);
    public static final String OZONE_SCM_SERVICE_ID = "OzoneScmService";
    public static final String OZONE_SCM_SERVICE_INSTANCE_ID = "OzoneScmServiceInstance";
    private static final int NO_PORT = -1;

    private HddsUtils() {
    }

    public static InetSocketAddress getScmAddressForClients(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address");
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Optional<Integer> port = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.client.address");
        return NetUtils.createSocketAddr((String)((String)host.get() + ":" + port.or((Object)9860)));
    }

    public static InetSocketAddress getScmAddressForBlockClients(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.block.client.address");
        if (!host.isPresent() && !(host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address")).isPresent()) {
            throw new IllegalArgumentException("ozone.scm.block.client.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        Optional<Integer> port = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.block.client.address");
        return NetUtils.createSocketAddr((String)((String)host.get() + ":" + port.or((Object)9863)));
    }

    public static Optional<String> getHostNameFromConfigKeys(Configuration conf, String ... keys) {
        for (String key : keys) {
            String value = conf.getTrimmed(key);
            Optional<String> hostName = HddsUtils.getHostName(value);
            if (!hostName.isPresent()) continue;
            return hostName;
        }
        return Optional.absent();
    }

    public static Optional<String> getHostName(String value) {
        if (value == null || value.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)HostAndPort.fromString((String)value).getHostText());
    }

    public static Optional<Integer> getHostPort(String value) {
        if (value == null || value.isEmpty()) {
            return Optional.absent();
        }
        int port = HostAndPort.fromString((String)value).getPortOrDefault(-1);
        if (port == -1) {
            return Optional.absent();
        }
        return Optional.of((Object)port);
    }

    public static Optional<Integer> getPortNumberFromConfigKeys(Configuration conf, String ... keys) {
        for (String key : keys) {
            String value = conf.getTrimmed(key);
            Optional<Integer> hostPort = HddsUtils.getHostPort(value);
            if (!hostPort.isPresent()) continue;
            return hostPort;
        }
        return Optional.absent();
    }

    public static Collection<InetSocketAddress> getSCMAddresses(Configuration conf) throws IllegalArgumentException {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        Collection names = conf.getTrimmedStringCollection("ozone.scm.names");
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("ozone.scm.names need to be a set of valid DNS names or IP addresses. Null or empty address list found.");
        }
        Optional defaultPort = Optional.of((Object)9861);
        for (String address : names) {
            Optional<String> hostname = HddsUtils.getHostName(address);
            if (!hostname.isPresent()) {
                throw new IllegalArgumentException("Invalid hostname for SCM: " + hostname);
            }
            Optional<Integer> port = HddsUtils.getHostPort(address);
            InetSocketAddress addr = NetUtils.createSocketAddr((String)((String)hostname.get()), (int)((Integer)port.or(defaultPort.get())));
            addresses.add(addr);
        }
        return addresses;
    }

    public static boolean isHddsEnabled(Configuration conf) {
        String securityEnabled = conf.get("hadoop.security.authentication", "simple");
        boolean securityAuthorizationEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (securityEnabled.equals("kerberos") || securityAuthorizationEnabled) {
            LOG.error("Ozone is not supported in a security enabled cluster. ");
            return false;
        }
        return conf.getBoolean("ozone.enabled", false);
    }

    public static String getDatanodeIdFilePath(Configuration conf) {
        String dataNodeIDPath = conf.get("ozone.scm.datanode.id");
        if (dataNodeIDPath == null) {
            String metaPath = conf.get("ozone.metadata.dirs");
            if (Strings.isNullOrEmpty((String)metaPath)) {
                throw new IllegalArgumentException("Unable to locate meta datadirectory when getting datanode id path");
            }
            dataNodeIDPath = Paths.get(metaPath, "datanode.id").toString();
        }
        return dataNodeIDPath;
    }

    public static String getHostName(Configuration conf) throws UnknownHostException {
        String name = conf.get("dfs.datanode.hostname");
        if (name == null) {
            String dnsInterface = conf.get("hadoop.security.dns.interface");
            String nameServer = conf.get("hadoop.security.dns.nameserver");
            boolean fallbackToHosts = false;
            if (dnsInterface == null) {
                dnsInterface = conf.get("dfs.datanode.dns.interface");
                nameServer = conf.get("dfs.datanode.dns.nameserver");
            } else {
                fallbackToHosts = true;
            }
            name = DNS.getDefaultHost((String)dnsInterface, (String)nameServer, (boolean)fallbackToHosts);
        }
        return name;
    }

    public static boolean isReadOnly(ContainerProtos.ContainerCommandRequestProto proto) {
        switch (proto.getCmdType()) {
            case ReadContainer: 
            case ReadChunk: 
            case ListKey: 
            case GetKey: 
            case GetSmallFile: 
            case ListContainer: 
            case ListChunk: 
            case GetCommittedBlockLength: {
                return true;
            }
        }
        return false;
    }
}

