/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.Closeable;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.shaded.io.grpc.Channel;
import org.apache.ratis.shaded.io.grpc.ManagedChannel;
import org.apache.ratis.shaded.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.shaded.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.util.TimeDuration;

public class RaftServerProtocolClient
implements Closeable {
    private final ManagedChannel channel;
    private final TimeDuration requestTimeoutDuration;
    private final RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub blockingStub;
    private final RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub asyncStub;

    public RaftServerProtocolClient(RaftPeer target, int flowControlWindow, TimeDuration requestTimeoutDuration) {
        this.channel = NettyChannelBuilder.forTarget((String)target.getAddress()).usePlaintext(true).flowControlWindow(flowControlWindow).build();
        this.blockingStub = RaftServerProtocolServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = RaftServerProtocolServiceGrpc.newStub((Channel)this.channel);
        this.requestTimeoutDuration = requestTimeoutDuration;
    }

    @Override
    public void close() {
        this.channel.shutdownNow();
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) {
        RaftProtos.RequestVoteReplyProto r = ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).requestVote(request);
        return r;
    }

    StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(StreamObserver<RaftProtos.AppendEntriesReplyProto> responseHandler) {
        return this.asyncStub.appendEntries(responseHandler);
    }

    StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseHandler) {
        return ((RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub)this.asyncStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).installSnapshot(responseHandler);
    }
}

