/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.RaftGRpcService;
import org.apache.ratis.grpc.RaftGrpcUtil;
import org.apache.ratis.grpc.server.RaftServerProtocolClient;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;

public class GRpcLogAppender
extends LogAppender {
    private final RaftGRpcService rpcService;
    private final Map<Long, RaftProtos.AppendEntriesRequestProto> pendingRequests;
    private final int maxPendingRequestsNum;
    private long callId = 0L;
    private volatile boolean firstResponseReceived = false;
    private final TimeDuration requestTimeoutDuration;
    private final TimeoutScheduler scheduler = TimeoutScheduler.newInstance((int)1);
    private volatile StreamObserver<RaftProtos.AppendEntriesRequestProto> appendLogRequestObserver;

    public GRpcLogAppender(RaftServerImpl server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
        this.rpcService = (RaftGRpcService)server.getServerRpc();
        this.maxPendingRequestsNum = GrpcConfigKeys.Server.leaderOutstandingAppendsMax(server.getProxy().getProperties());
        this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)server.getProxy().getProperties());
        this.pendingRequests = new ConcurrentHashMap<Long, RaftProtos.AppendEntriesRequestProto>();
    }

    private RaftServerProtocolClient getClient() throws IOException {
        return (RaftServerProtocolClient)this.rpcService.getProxies().getProxy(this.follower.getPeer().getId());
    }

    private synchronized void resetClient(RaftProtos.AppendEntriesRequestProto request) {
        this.rpcService.getProxies().resetProxy(this.follower.getPeer().getId());
        this.appendLogRequestObserver = null;
        this.firstResponseReceived = false;
        long nextIndex = request != null && request.hasPreviousLog() ? request.getPreviousLog().getIndex() + 1L : this.raftLog.getStartIndex();
        this.clearPendingRequests(nextIndex);
    }

    protected void runAppenderImpl() throws IOException {
        while (this.isAppenderRunning()) {
            if (this.shouldSendRequest()) {
                SnapshotInfo snapshot = this.shouldInstallSnapshot();
                if (snapshot != null) {
                    this.installSnapshot(snapshot);
                } else if (!this.shouldWait()) {
                    this.appendLog();
                }
            }
            this.checkSlowness();
            this.mayWait();
        }
        Optional.ofNullable(this.appendLogRequestObserver).ifPresent(StreamObserver::onCompleted);
    }

    private long getWaitTimeMs() {
        if (!this.shouldSendRequest()) {
            return this.getHeartbeatRemainingTime();
        }
        if (this.shouldWait()) {
            return this.halfMinTimeoutMs;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayWait() {
        long waitTimeMs = this.getWaitTimeMs();
        if (waitTimeMs <= 0L) {
            return;
        }
        GRpcLogAppender gRpcLogAppender = this;
        synchronized (gRpcLogAppender) {
            try {
                LOG.trace("{}: wait {}ms", (Object)this, (Object)waitTimeMs);
                ((Object)((Object)this)).wait(waitTimeMs);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)((Object)this) + ": Wait interrupted by " + ie);
            }
        }
    }

    protected boolean shouldSendRequest() {
        return this.appendLogRequestObserver == null || super.shouldSendRequest();
    }

    private boolean shouldWait() {
        int size = this.pendingRequests.size();
        if (size == 0) {
            return false;
        }
        return !this.firstResponseReceived || size >= this.maxPendingRequestsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLog() throws IOException {
        StreamObserver<RaftProtos.AppendEntriesRequestProto> s;
        RaftProtos.AppendEntriesRequestProto pending;
        GRpcLogAppender gRpcLogAppender = this;
        synchronized (gRpcLogAppender) {
            pending = this.createRequest(this.callId++);
            if (pending == null) {
                return;
            }
            this.pendingRequests.put(pending.getServerRequest().getCallId(), pending);
            this.updateNextIndex(pending);
            if (this.appendLogRequestObserver == null) {
                this.appendLogRequestObserver = this.getClient().appendEntries(new AppendLogResponseHandler());
            }
            s = this.appendLogRequestObserver;
        }
        if (this.isAppenderRunning()) {
            this.sendRequest(pending, s);
        }
    }

    private void sendRequest(RaftProtos.AppendEntriesRequestProto request, StreamObserver<RaftProtos.AppendEntriesRequestProto> s) {
        CodeInjectionForTesting.execute((String)RaftGRpcService.GRPC_SEND_SERVER_REQUEST, (Object)this.server.getId(), null, (Object[])new Object[]{request});
        s.onNext((Object)request);
        this.scheduler.onTimeout(this.requestTimeoutDuration, () -> this.timeoutAppendRequest(request), LOG, () -> "Timeout check failed for append entry request: " + request);
        this.follower.updateLastRpcSendTime();
    }

    private void timeoutAppendRequest(RaftProtos.AppendEntriesRequestProto request) {
        RaftProtos.AppendEntriesRequestProto pendingRequest = this.pendingRequests.remove(request.getServerRequest().getCallId());
        if (pendingRequest != null) {
            String err = (Object)((Object)this) + ": appendEntries Timeout, request=" + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)pendingRequest.getServerRequest());
            LOG.warn(err);
        }
    }

    private void updateNextIndex(RaftProtos.AppendEntriesRequestProto request) {
        int count = request.getEntriesCount();
        if (count > 0) {
            this.follower.updateNextIndex(request.getEntries(count - 1).getIndex() + 1L);
        }
    }

    private void clearPendingRequests(long newNextIndex) {
        this.pendingRequests.clear();
        this.follower.decreaseNextIndex(newNextIndex);
    }

    protected synchronized void onSuccess(RaftProtos.AppendEntriesReplyProto reply) {
        boolean updateMatchIndex;
        RaftProtos.AppendEntriesRequestProto request = this.pendingRequests.remove(reply.getServerReply().getCallId());
        if (request == null) {
            LOG.warn("Ignoring reply: " + reply);
            return;
        }
        this.updateCommitIndex(request.getLeaderCommit());
        long replyNextIndex = reply.getNextIndex();
        Objects.requireNonNull(request, () -> "Got reply with next index " + replyNextIndex + " but the pending queue is empty");
        long lastIndex = replyNextIndex - 1L;
        if (request.getEntriesCount() == 0) {
            Preconditions.assertTrue((!request.hasPreviousLog() || lastIndex == request.getPreviousLog().getIndex() ? 1 : 0) != 0, (String)"reply's next index is %s, request's previous is %s", (Object[])new Object[]{replyNextIndex, request.getPreviousLog()});
            updateMatchIndex = request.hasPreviousLog() && this.follower.getMatchIndex() < lastIndex;
        } else {
            long lastEntryIndex = request.getEntries(request.getEntriesCount() - 1).getIndex();
            Preconditions.assertTrue((lastIndex == lastEntryIndex ? 1 : 0) != 0, (String)"reply's next index is %s, request's last entry index is %s", (Object[])new Object[]{replyNextIndex, lastEntryIndex});
            updateMatchIndex = true;
        }
        if (updateMatchIndex) {
            this.follower.updateMatchIndex(lastIndex);
            this.submitEventOnSuccessAppend();
        }
    }

    private void onNotLeader(RaftProtos.AppendEntriesReplyProto reply) {
        this.checkResponseTerm(reply.getTerm());
    }

    private synchronized void onInconsistency(RaftProtos.AppendEntriesReplyProto reply) {
        RaftProtos.AppendEntriesRequestProto request = this.pendingRequests.remove(reply.getServerReply().getCallId());
        if (request == null) {
            LOG.warn("{}: Ignoring {}", (Object)this.server.getId(), (Object)reply);
            return;
        }
        Preconditions.assertTrue((boolean)request.hasPreviousLog());
        if (request.getPreviousLog().getIndex() >= reply.getNextIndex()) {
            this.clearPendingRequests(reply.getNextIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSnapshot(SnapshotInfo snapshot) {
        LOG.info("{}: follower {}'s next index is {}, log's start index is {}, need to install snapshot", new Object[]{this.server.getId(), this.follower.getPeer(), this.follower.getNextIndex(), this.raftLog.getStartIndex()});
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        String requestId = UUID.randomUUID().toString();
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(responseHandler);
            for (RaftProtos.InstallSnapshotRequestProto request : new LogAppender.SnapshotRequestIter((LogAppender)this, snapshot, requestId)) {
                if (!this.isAppenderRunning()) break;
                snapshotRequestObserver.onNext((Object)request);
                this.follower.updateLastRpcSendTime();
                responseHandler.addPending(request);
            }
            snapshotRequestObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.warn("{} failed to install snapshot {}. Exception: {}", new Object[]{this, snapshot.getFiles(), e});
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError((Throwable)e);
            }
            return;
        }
        Object object = this;
        synchronized (object) {
            while (this.isAppenderRunning() && !responseHandler.isDone()) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (responseHandler.hasAllResponse()) {
            this.follower.updateMatchIndex(snapshot.getTermIndex().getIndex());
            this.follower.updateNextIndex(snapshot.getTermIndex().getIndex() + 1L);
            LOG.info("{}: install snapshot-{} successfully on follower {}", new Object[]{this.server.getId(), snapshot.getTermIndex().getIndex(), this.follower.getPeer()});
        }
    }

    private class InstallSnapshotResponseHandler
    implements StreamObserver<RaftProtos.InstallSnapshotReplyProto> {
        private final Queue<Integer> pending;
        private final AtomicBoolean done = new AtomicBoolean(false);

        InstallSnapshotResponseHandler() {
            this.pending = new LinkedList<Integer>();
        }

        synchronized void addPending(RaftProtos.InstallSnapshotRequestProto request) {
            this.pending.offer(request.getRequestIndex());
        }

        synchronized void removePending(RaftProtos.InstallSnapshotReplyProto reply) {
            int index = this.pending.poll();
            Preconditions.assertTrue((index == reply.getRequestIndex() ? 1 : 0) != 0);
        }

        boolean isDone() {
            return this.done.get();
        }

        void close() {
            this.done.set(true);
            GRpcLogAppender.this.notifyAppend();
        }

        synchronized boolean hasAllResponse() {
            return this.pending.isEmpty();
        }

        public void onNext(RaftProtos.InstallSnapshotReplyProto reply) {
            LogAppender.LOG.debug("{} received {} response from {}", new Object[]{GRpcLogAppender.this.server.getId(), !GRpcLogAppender.this.firstResponseReceived ? "the first" : "a", GRpcLogAppender.this.follower.getPeer()});
            GRpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GRpcLogAppender.this.firstResponseReceived) {
                GRpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: {
                    this.removePending(reply);
                    break;
                }
                case NOT_LEADER: {
                    GRpcLogAppender.this.checkResponseTerm(reply.getTerm());
                    break;
                }
            }
        }

        public void onError(Throwable t) {
            if (!GRpcLogAppender.this.isAppenderRunning()) {
                LogAppender.LOG.info("{} is stopped", (Object)GRpcLogAppender.this);
                return;
            }
            LogAppender.LOG.info("{} got error when installing snapshot to {}, exception: {}", new Object[]{GRpcLogAppender.this.server.getId(), GRpcLogAppender.this.follower.getPeer(), t});
            GRpcLogAppender.this.resetClient(null);
            this.close();
        }

        public void onCompleted() {
            LogAppender.LOG.info("{} stops sending snapshots to follower {}", (Object)GRpcLogAppender.this.server.getId(), (Object)GRpcLogAppender.this.follower);
            this.close();
        }
    }

    private class AppendLogResponseHandler
    implements StreamObserver<RaftProtos.AppendEntriesReplyProto> {
        private AppendLogResponseHandler() {
        }

        public void onNext(RaftProtos.AppendEntriesReplyProto reply) {
            LogAppender.LOG.debug("{} received {} response from {}", new Object[]{GRpcLogAppender.this.server.getId(), !GRpcLogAppender.this.firstResponseReceived ? "the first" : "a", GRpcLogAppender.this.follower.getPeer()});
            GRpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GRpcLogAppender.this.firstResponseReceived) {
                GRpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: {
                    GRpcLogAppender.this.onSuccess(reply);
                    break;
                }
                case NOT_LEADER: {
                    GRpcLogAppender.this.onNotLeader(reply);
                    break;
                }
                case INCONSISTENCY: {
                    GRpcLogAppender.this.onInconsistency(reply);
                    break;
                }
            }
            GRpcLogAppender.this.notifyAppend();
        }

        public void onError(Throwable t) {
            if (!GRpcLogAppender.this.isAppenderRunning()) {
                LogAppender.LOG.info("{} is stopped", (Object)GRpcLogAppender.this);
                return;
            }
            RaftGrpcUtil.warn(LogAppender.LOG, () -> GRpcLogAppender.this.server.getId() + ": Failed appendEntries to " + GRpcLogAppender.this.follower.getPeer(), t);
            long callId = RaftGrpcUtil.getCallId(t);
            GRpcLogAppender.this.resetClient((RaftProtos.AppendEntriesRequestProto)GRpcLogAppender.this.pendingRequests.get(callId));
        }

        public void onCompleted() {
            LogAppender.LOG.info("{} stops appending log entries to follower {}", (Object)GRpcLogAppender.this.server.getId(), (Object)GRpcLogAppender.this.follower);
        }
    }
}

