/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.RaftGrpcUtil;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.shaded.io.grpc.Channel;
import org.apache.ratis.shaded.io.grpc.ManagedChannel;
import org.apache.ratis.shaded.io.grpc.StatusRuntimeException;
import org.apache.ratis.shaded.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.shaded.proto.grpc.AdminProtocolServiceGrpc;
import org.apache.ratis.shaded.proto.grpc.RaftClientProtocolServiceGrpc;
import org.apache.ratis.util.CheckedSupplier;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftClientProtocolClient
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClientProtocolClient.class);
    private final Supplier<String> name;
    private final RaftPeer target;
    private final ManagedChannel channel;
    private final TimeDuration requestTimeoutDuration;
    private final TimeoutScheduler scheduler = TimeoutScheduler.newInstance((int)1);
    private final RaftClientProtocolServiceGrpc.RaftClientProtocolServiceBlockingStub blockingStub;
    private final RaftClientProtocolServiceGrpc.RaftClientProtocolServiceStub asyncStub;
    private final AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub adminBlockingStub;
    private final AtomicReference<AsyncStreamObservers> appendStreamObservers = new AtomicReference();

    public RaftClientProtocolClient(ClientId id, RaftPeer target, RaftProperties properties) {
        this.name = JavaUtils.memoize(() -> id + "->" + target.getId());
        this.target = target;
        SizeInBytes flowControlWindow = GrpcConfigKeys.flowControlWindow(properties, arg_0 -> ((Logger)LOG).debug(arg_0));
        SizeInBytes maxMessageSize = GrpcConfigKeys.messageSizeMax(properties, arg_0 -> ((Logger)LOG).debug(arg_0));
        this.channel = NettyChannelBuilder.forTarget((String)target.getAddress()).usePlaintext(true).flowControlWindow(flowControlWindow.getSizeInt()).maxMessageSize(maxMessageSize.getSizeInt()).build();
        this.blockingStub = RaftClientProtocolServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = RaftClientProtocolServiceGrpc.newStub((Channel)this.channel);
        this.adminBlockingStub = AdminProtocolServiceGrpc.newBlockingStub((Channel)this.channel);
        this.requestTimeoutDuration = RaftClientConfigKeys.Rpc.requestTimeout((RaftProperties)properties);
    }

    String getName() {
        return this.name.get();
    }

    @Override
    public void close() {
        AsyncStreamObservers observers = this.appendStreamObservers.get();
        if (observers != null) {
            observers.close();
        }
        this.channel.shutdownNow();
    }

    RaftProtos.RaftClientReplyProto groupAdd(RaftProtos.GroupManagementRequestProto request) throws IOException {
        return RaftClientProtocolClient.blockingCall((CheckedSupplier<RaftProtos.RaftClientReplyProto, StatusRuntimeException>)((CheckedSupplier)() -> ((AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub)this.adminBlockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).groupManagement(request)));
    }

    RaftProtos.ServerInformationReplyProto serverInformation(RaftProtos.ServerInformationRequestProto request) throws IOException {
        return ((AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub)this.adminBlockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).serverInformation(request);
    }

    RaftProtos.RaftClientReplyProto setConfiguration(RaftProtos.SetConfigurationRequestProto request) throws IOException {
        return RaftClientProtocolClient.blockingCall((CheckedSupplier<RaftProtos.RaftClientReplyProto, StatusRuntimeException>)((CheckedSupplier)() -> ((RaftClientProtocolServiceGrpc.RaftClientProtocolServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).setConfiguration(request)));
    }

    private static RaftProtos.RaftClientReplyProto blockingCall(CheckedSupplier<RaftProtos.RaftClientReplyProto, StatusRuntimeException> supplier) throws IOException {
        try {
            return (RaftProtos.RaftClientReplyProto)supplier.get();
        }
        catch (StatusRuntimeException e) {
            throw RaftGrpcUtil.unwrapException(e);
        }
    }

    StreamObserver<RaftProtos.RaftClientRequestProto> append(StreamObserver<RaftProtos.RaftClientReplyProto> responseHandler) {
        return this.asyncStub.append(responseHandler);
    }

    StreamObserver<RaftProtos.RaftClientRequestProto> appendWithTimeout(StreamObserver<RaftProtos.RaftClientReplyProto> responseHandler) {
        return ((RaftClientProtocolServiceGrpc.RaftClientProtocolServiceStub)this.asyncStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).append(responseHandler);
    }

    AsyncStreamObservers getAppendStreamObservers() {
        return this.appendStreamObservers.updateAndGet(a -> a != null ? a : new AsyncStreamObservers());
    }

    public RaftPeer getTarget() {
        return this.target;
    }

    class AsyncStreamObservers
    implements Closeable {
        private final AtomicReference<Map<Long, CompletableFuture<RaftClientReply>>> replies = new AtomicReference(new ConcurrentHashMap());
        private final StreamObserver<RaftProtos.RaftClientReplyProto> replyStreamObserver = new StreamObserver<RaftProtos.RaftClientReplyProto>(){

            public void onNext(RaftProtos.RaftClientReplyProto proto) {
                long callId = proto.getRpcReply().getCallId();
                try {
                    RaftClientReply reply = ClientProtoUtils.toRaftClientReply((RaftProtos.RaftClientReplyProto)proto);
                    NotLeaderException nle = reply.getNotLeaderException();
                    if (nle != null) {
                        AsyncStreamObservers.this.completeReplyExceptionally((Throwable)nle, NotLeaderException.class.getName());
                        return;
                    }
                    AsyncStreamObservers.this.handleReplyFuture(callId, f -> f.complete(reply));
                }
                catch (Throwable t) {
                    AsyncStreamObservers.this.handleReplyFuture(callId, f -> f.completeExceptionally(t));
                }
            }

            public void onError(Throwable t) {
                IOException ioe = RaftGrpcUtil.unwrapIOException(t);
                AsyncStreamObservers.this.completeReplyExceptionally(ioe, "onError");
            }

            public void onCompleted() {
                AsyncStreamObservers.this.completeReplyExceptionally(null, "completed");
            }
        };
        private final StreamObserver<RaftProtos.RaftClientRequestProto> requestStreamObserver = RaftClientProtocolClient.this.append(this.replyStreamObserver);

        AsyncStreamObservers() {
        }

        CompletableFuture<RaftClientReply> onNext(RaftClientRequest request) {
            Map<Long, CompletableFuture<RaftClientReply>> map = this.replies.get();
            if (map == null) {
                return JavaUtils.completeExceptionally((Throwable)new IOException("Already closed."));
            }
            CompletableFuture<RaftClientReply> f = new CompletableFuture<RaftClientReply>();
            CollectionUtils.putNew((Object)request.getCallId(), f, map, () -> RaftClientProtocolClient.this.getName() + ":" + this.getClass().getSimpleName());
            try {
                this.requestStreamObserver.onNext((Object)ClientProtoUtils.toRaftClientRequestProto((RaftClientRequest)request));
                RaftClientProtocolClient.this.scheduler.onTimeout(RaftClientProtocolClient.this.requestTimeoutDuration, () -> this.timeoutCheck(request), LOG, () -> "Timeout check failed for client request: " + request);
            }
            catch (Throwable t) {
                this.handleReplyFuture(request.getCallId(), future -> future.completeExceptionally(t));
            }
            return f;
        }

        private void timeoutCheck(RaftClientRequest request) {
            this.handleReplyFuture(request.getCallId(), f -> f.completeExceptionally(new IOException("Request timeout " + RaftClientProtocolClient.this.requestTimeoutDuration + ": " + request)));
        }

        private void handleReplyFuture(long callId, Consumer<CompletableFuture<RaftClientReply>> handler) {
            Optional.ofNullable(this.replies.get()).map(replyMap -> (CompletableFuture)replyMap.remove(callId)).ifPresent(handler);
        }

        @Override
        public void close() {
            this.requestStreamObserver.onCompleted();
            this.completeReplyExceptionally(null, "close");
        }

        private void completeReplyExceptionally(Throwable t, String event) {
            RaftClientProtocolClient.this.appendStreamObservers.compareAndSet(this, null);
            Map map = this.replies.getAndSet(null);
            if (map == null) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                CompletableFuture f = (CompletableFuture)entry.getValue();
                if (f.isDone()) continue;
                f.completeExceptionally(t != null ? t : new IOException(RaftClientProtocolClient.this.getName() + ": Stream " + event + ": no reply for async request cid=" + entry.getKey()));
            }
        }
    }
}

