/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.RaftGRpcService;
import org.apache.ratis.grpc.client.GrpcClientRpc;
import org.apache.ratis.grpc.server.GRpcLogAppender;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerFactory;

public class GrpcFactory
implements ServerFactory,
ClientFactory {
    public GrpcFactory(Parameters parameters) {
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public LogAppender newLogAppender(RaftServerImpl server, LeaderState state, FollowerInfo f) {
        return new GRpcLogAppender(server, state, f);
    }

    public RaftGRpcService newRaftServerRpc(RaftServer server) {
        return ((RaftGRpcService.Builder)RaftGRpcService.newBuilder().setServer(server)).build();
    }

    public GrpcClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
        return new GrpcClientRpc(clientId, properties);
    }
}

