/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GrpcConfigKeys {
    public static final String PREFIX = "raft.grpc";
    public static final String MESSAGE_SIZE_MAX_KEY = "raft.grpc.message.size.max";
    public static final SizeInBytes MESSAGE_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"64MB");
    public static final String FLOW_CONTROL_WINDOW_KEY = "raft.grpc.flow.control.window";
    public static final SizeInBytes FLOW_CONTROL_WINDOW_DEFAULT = SizeInBytes.valueOf((String)"1MB");

    public static SizeInBytes messageSizeMax(RaftProperties properties, Consumer<String> logger) {
        return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)MESSAGE_SIZE_MAX_KEY, (SizeInBytes)MESSAGE_SIZE_MAX_DEFAULT, logger, (BiConsumer[])new BiConsumer[0]);
    }

    public static void setMessageSizeMax(RaftProperties properties, SizeInBytes maxMessageSize) {
        ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)MESSAGE_SIZE_MAX_KEY, (SizeInBytes)maxMessageSize, (BiConsumer[])new BiConsumer[0]);
    }

    public static SizeInBytes flowControlWindow(RaftProperties properties, Consumer<String> logger) {
        return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)FLOW_CONTROL_WINDOW_KEY, (SizeInBytes)FLOW_CONTROL_WINDOW_DEFAULT, logger, (BiConsumer[])new BiConsumer[0]);
    }

    public static void setFlowControlWindow(RaftProperties properties, SizeInBytes flowControlWindowSize) {
        ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)FLOW_CONTROL_WINDOW_KEY, (SizeInBytes)flowControlWindowSize, (BiConsumer[])new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(GrpcConfigKeys.class);
    }

    public static interface OutputStream {
        public static final Logger LOG = LoggerFactory.getLogger(OutputStream.class);
        public static final String PREFIX = "raft.grpc.outputstream";
        public static final String BUFFER_SIZE_KEY = "raft.grpc.outputstream.buffer.size";
        public static final SizeInBytes BUFFER_SIZE_DEFAULT = SizeInBytes.valueOf((String)"64KB");
        public static final String RETRY_TIMES_KEY = "raft.grpc.outputstream.retry.times";
        public static final int RETRY_TIMES_DEFAULT = 5;
        public static final String RETRY_INTERVAL_KEY = "raft.grpc.outputstream.retry.interval";
        public static final TimeDuration RETRY_INTERVAL_DEFAULT = RaftClientConfigKeys.Rpc.RETRY_INTERVAL_DEFAULT;
        public static final String OUTSTANDING_APPENDS_MAX_KEY = "raft.grpc.outputstream.outstanding.appends.max";
        public static final int OUTSTANDING_APPENDS_MAX_DEFAULT = 128;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).debug(arg_0);
        }

        public static SizeInBytes bufferSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)BUFFER_SIZE_KEY, (SizeInBytes)BUFFER_SIZE_DEFAULT, OutputStream.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setBufferSize(RaftProperties properties, SizeInBytes bufferSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)BUFFER_SIZE_KEY, (SizeInBytes)bufferSize, (BiConsumer[])new BiConsumer[0]);
        }

        public static int retryTimes(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)RETRY_TIMES_KEY, (int)5, OutputStream.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)1)});
        }

        public static void setRetryTimes(RaftProperties properties, int retryTimes) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)RETRY_TIMES_KEY, (int)retryTimes, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration retryInterval(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(RETRY_INTERVAL_DEFAULT.getUnit()), (String)RETRY_INTERVAL_KEY, (TimeDuration)RETRY_INTERVAL_DEFAULT, OutputStream.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setRetryInterval(RaftProperties properties, TimeDuration retryInterval) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)RETRY_INTERVAL_KEY, (TimeDuration)retryInterval, (BiConsumer[])new BiConsumer[0]);
        }

        public static int outstandingAppendsMax(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)OUTSTANDING_APPENDS_MAX_KEY, (int)128, OutputStream.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setOutstandingAppendsMax(RaftProperties properties, int maxOutstandingAppends) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)OUTSTANDING_APPENDS_MAX_KEY, (int)maxOutstandingAppends, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Server {
        public static final Logger LOG = LoggerFactory.getLogger(Server.class);
        public static final String PREFIX = "raft.grpc.server";
        public static final String PORT_KEY = "raft.grpc.server.port";
        public static final int PORT_DEFAULT = 0;
        public static final String LEADER_OUTSTANDING_APPENDS_MAX_KEY = "raft.grpc.server.leader.outstanding.appends.max";
        public static final int LEADER_OUTSTANDING_APPENDS_MAX_DEFAULT = 128;

        public static Consumer<String> getDefaultLog() {
            return arg_0 -> ((Logger)LOG).info(arg_0);
        }

        public static int port(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)PORT_KEY, (int)0, Server.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0), ConfUtils.requireMax((int)65536)});
        }

        public static void setPort(RaftProperties properties, int port) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)PORT_KEY, (int)port, (BiConsumer[])new BiConsumer[0]);
        }

        public static int leaderOutstandingAppendsMax(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)LEADER_OUTSTANDING_APPENDS_MAX_KEY, (int)128, Server.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setLeaderOutstandingAppendsMax(RaftProperties properties, int maxAppend) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)LEADER_OUTSTANDING_APPENDS_MAX_KEY, (int)maxAppend, (BiConsumer[])new BiConsumer[0]);
        }
    }
}

