/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.storage.RaftLog;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateMachineUpdater
implements Runnable {
    static final Logger LOG = LoggerFactory.getLogger(StateMachineUpdater.class);
    private final RaftProperties properties;
    private final StateMachine stateMachine;
    private final RaftServerImpl server;
    private final RaftLog raftLog;
    private volatile long lastAppliedIndex;
    private final boolean autoSnapshotEnabled;
    private final long autoSnapshotThreshold;
    private long lastSnapshotIndex;
    private final Thread updater;
    private volatile State state = State.RUNNING;

    StateMachineUpdater(StateMachine stateMachine, RaftServerImpl server, RaftLog raftLog, long lastAppliedIndex, RaftProperties properties) {
        this.properties = properties;
        this.stateMachine = stateMachine;
        this.server = server;
        this.raftLog = raftLog;
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastSnapshotIndex = lastAppliedIndex;
        this.autoSnapshotEnabled = RaftServerConfigKeys.Snapshot.autoTriggerEnabled(properties);
        this.autoSnapshotThreshold = RaftServerConfigKeys.Snapshot.autoTriggerThreshold(properties);
        this.updater = new Daemon((Runnable)this);
    }

    void start() {
        this.updater.start();
    }

    void stop() {
        this.state = State.STOP;
        this.updater.interrupt();
        try {
            this.stateMachine.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void reloadStateMachine() {
        this.state = State.RELOAD;
        this.notifyUpdater();
    }

    synchronized void notifyUpdater() {
        this.notifyAll();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + this.raftLog.getSelfId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning()) {
            String s;
            try {
                StateMachineUpdater stateMachineUpdater = this;
                synchronized (stateMachineUpdater) {
                    while (this.lastAppliedIndex >= this.raftLog.getLastCommittedIndex()) {
                        this.wait();
                    }
                }
                long committedIndex = this.raftLog.getLastCommittedIndex();
                Preconditions.assertTrue((this.lastAppliedIndex < committedIndex ? 1 : 0) != 0);
                if (this.state == State.RELOAD) {
                    Preconditions.assertTrue((this.stateMachine.getLifeCycleState() == LifeCycle.State.PAUSED ? 1 : 0) != 0);
                    this.stateMachine.reinitialize();
                    SnapshotInfo snapshot = this.stateMachine.getLatestSnapshot();
                    Preconditions.assertTrue((snapshot != null && snapshot.getIndex() > this.lastAppliedIndex ? 1 : 0) != 0, (String)"Snapshot: %s, lastAppliedIndex: %s", (Object[])new Object[]{snapshot, this.lastAppliedIndex});
                    this.lastAppliedIndex = snapshot.getIndex();
                    this.lastSnapshotIndex = snapshot.getIndex();
                    this.state = State.RUNNING;
                }
                MemoizedSupplier futures = MemoizedSupplier.valueOf(() -> new ArrayList());
                while (this.lastAppliedIndex < committedIndex) {
                    long nextIndex = this.lastAppliedIndex + 1L;
                    RaftProtos.LogEntryProto next = this.raftLog.get(nextIndex);
                    if (next != null) {
                        CompletableFuture<Message> f;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{}: applying nextIndex={}, nextLog={}", new Object[]{this, nextIndex, ServerProtoUtils.toString(next)});
                        }
                        if ((f = this.server.applyLogToStateMachine(next)) != null) {
                            ((List)futures.get()).add(f);
                        }
                        this.lastAppliedIndex = nextIndex;
                        continue;
                    }
                    LOG.debug("{}: logEntry {} is null. There may be snapshot to load. state:{}", new Object[]{this, nextIndex, this.state});
                    break;
                }
                if (!this.shouldTakeSnapshot(this.lastAppliedIndex)) continue;
                if (futures.isInitialized()) {
                    JavaUtils.allOf((List)((List)futures.get())).get();
                }
                this.stateMachine.takeSnapshot();
                this.lastSnapshotIndex = this.lastAppliedIndex;
            }
            catch (InterruptedException e) {
                if (!this.isRunning()) {
                    LOG.info("{}: the StateMachineUpdater is interrupted and will exit.", (Object)this);
                    continue;
                }
                s = this + ": the StateMachineUpdater is wrongly interrupted";
                ExitUtils.terminate((int)1, (String)s, (Throwable)e, (Logger)LOG);
            }
            catch (Throwable t) {
                s = this + ": the StateMachineUpdater hits Throwable";
                ExitUtils.terminate((int)2, (String)s, (Throwable)t, (Logger)LOG);
            }
        }
    }

    private boolean isRunning() {
        return this.state != State.STOP;
    }

    private boolean shouldTakeSnapshot(long currentAppliedIndex) {
        return this.autoSnapshotEnabled && this.state != State.RELOAD && currentAppliedIndex - this.lastSnapshotIndex >= this.autoSnapshotThreshold;
    }

    long getLastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    static enum State {
        RUNNING,
        STOP,
        RELOAD;

    }
}

