/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ConfigurationManager;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.RaftServerConstants;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.StateMachineUpdater;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.MemoryRaftLog;
import org.apache.ratis.server.storage.RaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.SegmentedRaftLog;
import org.apache.ratis.server.storage.SnapshotManager;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.Timestamp;

public class ServerState
implements Closeable {
    private final RaftPeerId selfId;
    private final RaftServerImpl server;
    private final RaftLog log;
    private final ConfigurationManager configurationManager;
    private final StateMachineUpdater stateMachineUpdater;
    private final RaftStorage storage;
    private final SnapshotManager snapshotManager;
    private volatile Timestamp lastNoLeaderTime;
    private final long leaderElectionTimeoutMs;
    private long currentTerm;
    private RaftPeerId leaderId;
    private RaftPeerId votedFor;
    private TermIndex latestInstalledSnapshot;

    ServerState(RaftPeerId id, RaftGroup group, RaftProperties prop, RaftServerImpl server, StateMachine stateMachine) throws IOException {
        this.selfId = id;
        this.server = server;
        RaftConfiguration initialConf = RaftConfiguration.newBuilder().setConf(group.getPeers()).build();
        this.configurationManager = new ConfigurationManager(initialConf);
        RaftServerImpl.LOG.info("{}: {}", (Object)id, (Object)this.configurationManager);
        File dir = RaftServerConfigKeys.storageDir(prop);
        this.storage = new RaftStorage(new File(dir, group.getGroupId().getUuid().toString()), RaftServerConstants.StartupOption.REGULAR);
        this.snapshotManager = new SnapshotManager(this.storage, id);
        long lastApplied = this.initStatemachine(stateMachine, group.getGroupId());
        this.leaderId = null;
        this.lastNoLeaderTime = new Timestamp();
        this.leaderElectionTimeoutMs = RaftServerConfigKeys.leaderElectionTimeout(prop).toInt(TimeUnit.MILLISECONDS);
        this.log = this.initLog(id, prop, lastApplied, entry -> {
            if (entry.getLogEntryBodyCase() == RaftProtos.LogEntryProto.LogEntryBodyCase.CONFIGURATIONENTRY) {
                this.setRaftConf(entry.getIndex(), ServerProtoUtils.toRaftConfiguration(entry));
            }
        });
        RaftLog.Metadata metadata = this.log.loadMetadata();
        this.currentTerm = metadata.getTerm();
        this.votedFor = metadata.getVotedFor();
        this.stateMachineUpdater = new StateMachineUpdater(stateMachine, server, this.log, lastApplied, prop);
    }

    private long initStatemachine(StateMachine sm, RaftGroupId groupId) throws IOException {
        sm.initialize(this.server.getProxy(), groupId, this.storage);
        this.storage.setStateMachineStorage(sm.getStateMachineStorage());
        SnapshotInfo snapshot = sm.getLatestSnapshot();
        if (snapshot == null || snapshot.getTermIndex().getIndex() < 0L) {
            return -1L;
        }
        RaftConfiguration raftConf = sm.getRaftConfiguration();
        if (raftConf != null) {
            this.setRaftConf(raftConf.getLogEntryIndex(), raftConf);
        }
        return snapshot.getIndex();
    }

    void start() {
        this.stateMachineUpdater.start();
    }

    private RaftLog initLog(RaftPeerId id, RaftProperties prop, long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> logConsumer) throws IOException {
        RaftLog log;
        if (RaftServerConfigKeys.Log.useMemory(prop)) {
            int maxBufferSize = RaftServerConfigKeys.Log.Appender.bufferCapacity(prop).getSizeInt();
            log = new MemoryRaftLog(id, maxBufferSize);
        } else {
            log = new SegmentedRaftLog(id, this.server, this.storage, lastIndexInSnapshot, prop);
        }
        log.open(lastIndexInSnapshot, logConsumer);
        return log;
    }

    public RaftConfiguration getRaftConf() {
        return this.configurationManager.getCurrent();
    }

    public RaftPeerId getSelfId() {
        return this.selfId;
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    boolean updateCurrentTerm(long newTerm) {
        if (newTerm > this.currentTerm) {
            this.currentTerm = newTerm;
            this.votedFor = null;
            this.setLeader(null, "updateCurrentTerm");
            return true;
        }
        return false;
    }

    RaftPeerId getLeaderId() {
        return this.leaderId;
    }

    boolean hasLeader() {
        return this.leaderId != null;
    }

    long initElection() {
        this.votedFor = this.selfId;
        this.setLeader(null, "initElection");
        return ++this.currentTerm;
    }

    void persistMetadata() throws IOException {
        this.log.writeMetadata(this.currentTerm, this.votedFor);
    }

    void grantVote(RaftPeerId candidateId) {
        this.votedFor = candidateId;
        this.setLeader(null, "grantVote");
    }

    void setLeader(RaftPeerId newLeaderId, String op) {
        if (!Objects.equals(this.leaderId, newLeaderId)) {
            String suffix;
            if (newLeaderId == null) {
                this.lastNoLeaderTime = new Timestamp();
                suffix = "";
            } else {
                Timestamp previous = this.lastNoLeaderTime;
                this.lastNoLeaderTime = null;
                suffix = ", leader elected after " + previous.elapsedTimeMs() + "ms";
            }
            RaftServerImpl.LOG.info("{}: change Leader from {} to {} at term {} for {}{}", new Object[]{this.selfId, this.leaderId, newLeaderId, this.getCurrentTerm(), op, suffix});
            this.leaderId = newLeaderId;
        }
    }

    boolean checkForExtendedNoLeader() {
        return this.getLastLeaderElapsedTimeMs() > this.leaderElectionTimeoutMs;
    }

    long getLastLeaderElapsedTimeMs() {
        Timestamp t = this.lastNoLeaderTime;
        return t == null ? 0L : t.elapsedTimeMs();
    }

    void becomeLeader() {
        this.setLeader(this.selfId, "becomeLeader");
    }

    public RaftLog getLog() {
        return this.log;
    }

    long applyLog(TransactionContext operation, ClientId clientId, long callId) throws StateMachineException {
        return this.log.append(this.currentTerm, operation, clientId, callId);
    }

    boolean recognizeLeader(RaftPeerId leaderId, long leaderTerm) {
        if (leaderTerm < this.currentTerm) {
            return false;
        }
        if (leaderTerm > this.currentTerm || this.leaderId == null) {
            return true;
        }
        return this.leaderId.equals((Object)leaderId);
    }

    boolean recognizeCandidate(RaftPeerId candidateId, long candidateTerm) {
        if (!this.getRaftConf().containsInConf(candidateId)) {
            return false;
        }
        if (candidateTerm > this.currentTerm) {
            return true;
        }
        if (candidateTerm == this.currentTerm) {
            return this.votedFor == null || this.votedFor.equals((Object)candidateId);
        }
        return false;
    }

    boolean isLogUpToDate(TermIndex candidateLastEntry) {
        TermIndex local = this.log.getLastEntryTermIndex();
        SnapshotInfo snapshot = this.server.getStateMachine().getLatestSnapshot();
        if (local == null && snapshot == null) {
            return true;
        }
        if (candidateLastEntry == null) {
            return false;
        }
        if (local == null || snapshot != null && snapshot.getIndex() > local.getIndex()) {
            local = snapshot.getTermIndex();
        }
        return local.compareTo(candidateLastEntry) <= 0;
    }

    public String toString() {
        return this.selfId + ":t" + this.currentTerm + ", leader=" + this.leaderId + ", voted=" + this.votedFor + ", raftlog=" + this.log + ", conf=" + this.getRaftConf();
    }

    boolean isConfCommitted() {
        return this.getLog().getLastCommittedIndex() >= this.getRaftConf().getLogEntryIndex();
    }

    void setRaftConf(long logIndex, RaftConfiguration conf) {
        this.configurationManager.addConfiguration(logIndex, conf);
        this.server.getServerRpc().addPeers(conf.getPeers());
        RaftServerImpl.LOG.info("{}: set configuration {} at {}", new Object[]{this.getSelfId(), conf, logIndex});
        RaftServerImpl.LOG.debug("{}: {}", (Object)this.getSelfId(), (Object)this.configurationManager);
    }

    void updateConfiguration(RaftProtos.LogEntryProto[] entries) {
        if (entries != null && entries.length > 0) {
            this.configurationManager.removeConfigurations(entries[0].getIndex());
            for (RaftProtos.LogEntryProto entry : entries) {
                if (!ProtoUtils.isConfigurationLogEntry((RaftProtos.LogEntryProto)entry)) continue;
                this.setRaftConf(entry.getIndex(), ServerProtoUtils.toRaftConfiguration(entry));
            }
        }
    }

    boolean updateStatemachine(long majorityIndex, long currentTerm) {
        if (this.log.updateLastCommitted(majorityIndex, currentTerm)) {
            this.stateMachineUpdater.notifyUpdater();
            return true;
        }
        return false;
    }

    void reloadStateMachine(long lastIndexInSnapshot, long currentTerm) {
        this.log.updateLastCommitted(lastIndexInSnapshot, currentTerm);
        this.stateMachineUpdater.reloadStateMachine();
    }

    @Override
    public void close() throws IOException {
        this.stateMachineUpdater.stop();
        RaftServerImpl.LOG.info("{} closes. The last applied log index is {}", (Object)this.getSelfId(), (Object)this.getLastAppliedIndex());
        this.log.close();
        this.storage.close();
    }

    public RaftStorage getStorage() {
        return this.storage;
    }

    void installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        StateMachine sm = this.server.getStateMachine();
        sm.pause();
        this.snapshotManager.installSnapshot(sm, request);
        this.log.syncWithSnapshot(request.getTermIndex().getIndex());
        this.latestInstalledSnapshot = ServerProtoUtils.toTermIndex(request.getTermIndex());
    }

    SnapshotInfo getLatestSnapshot() {
        return this.server.getStateMachine().getStateMachineStorage().getLatestSnapshot();
    }

    public TermIndex getLatestInstalledSnapshot() {
        return this.latestInstalledSnapshot;
    }

    public long getLastAppliedIndex() {
        return this.stateMachineUpdater.getLastAppliedIndex();
    }
}

