/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public class ServerProtoUtils {
    public static TermIndex toTermIndex(RaftProtos.TermIndexProto p) {
        return p == null ? null : TermIndex.newTermIndex(p.getTerm(), p.getIndex());
    }

    public static RaftProtos.TermIndexProto toTermIndexProto(TermIndex ti) {
        return ti == null ? null : RaftProtos.TermIndexProto.newBuilder().setTerm(ti.getTerm()).setIndex(ti.getIndex()).build();
    }

    public static TermIndex toTermIndex(RaftProtos.LogEntryProto entry) {
        return entry == null ? null : TermIndex.newTermIndex(entry.getTerm(), entry.getIndex());
    }

    public static String toTermIndexString(RaftProtos.LogEntryProto entry) {
        return TermIndex.toString(entry.getTerm(), entry.getIndex());
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry) {
        if (entry == null) {
            return null;
        }
        ByteString clientId = entry.getClientId();
        return ServerProtoUtils.toTermIndexString(entry) + entry.getLogEntryBodyCase() + ", " + (clientId.isEmpty() ? "<empty clientId>" : ClientId.valueOf((ByteString)clientId)) + ", cid=" + entry.getCallId();
    }

    public static String toString(RaftProtos.LogEntryProto ... entries) {
        return entries == null ? "null" : (entries.length == 0 ? "[]" : (entries.length == 1 ? ServerProtoUtils.toLogEntryString(entries[0]) : "" + Arrays.stream(entries).map(ServerProtoUtils::toLogEntryString).collect(Collectors.toList())));
    }

    public static String toString(RaftProtos.AppendEntriesReplyProto reply) {
        return ServerProtoUtils.toString(reply.getServerReply()) + "," + reply.getResult() + ",nextIndex:" + reply.getNextIndex() + ",term:" + reply.getTerm();
    }

    private static String toString(RaftProtos.RaftRpcReplyProto reply) {
        return reply.getRequestorId().toStringUtf8() + "->" + reply.getReplyId().toStringUtf8() + "," + reply.getSuccess();
    }

    public static RaftProtos.RaftConfigurationProto toRaftConfigurationProto(RaftConfiguration conf) {
        return RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers(ProtoUtils.toRaftPeerProtos(conf.getPeersInConf())).addAllOldPeers(ProtoUtils.toRaftPeerProtos(conf.getPeersInOldConf())).build();
    }

    public static RaftConfiguration toRaftConfiguration(RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((boolean)ProtoUtils.isConfigurationLogEntry((RaftProtos.LogEntryProto)entry));
        RaftProtos.RaftConfigurationProto proto = entry.getConfigurationEntry();
        RaftConfiguration.Builder b = RaftConfiguration.newBuilder().setConf(ProtoUtils.toRaftPeerArray((List)proto.getPeersList())).setLogEntryIndex(entry.getIndex());
        if (proto.getOldPeersCount() > 0) {
            b.setOldConf(ProtoUtils.toRaftPeerArray((List)proto.getOldPeersList()));
        }
        return b.build();
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftConfiguration conf, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setConfigurationEntry(ServerProtoUtils.toRaftConfigurationProto(conf)).build();
    }

    static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, boolean success) {
        return ClientProtoUtils.toRaftRpcReplyProtoBuilder((ByteString)requestorId.toByteString(), (ByteString)replyId.toByteString(), (RaftGroupId)groupId, (long)0L, (boolean)success);
    }

    public static RaftProtos.RequestVoteReplyProto toRequestVoteReplyProto(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, boolean success, long term, boolean shouldShutdown) {
        return RaftProtos.RequestVoteReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, groupId, success)).setTerm(term).setShouldShutdown(shouldShutdown).build();
    }

    static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder((ByteString)requestorId.toByteString(), (ByteString)replyId.toByteString(), (RaftGroupId)groupId, (long)0L, (long)0L);
    }

    public static RaftProtos.RequestVoteRequestProto toRequestVoteRequestProto(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, long term, TermIndex lastEntry) {
        RaftProtos.RequestVoteRequestProto.Builder b = RaftProtos.RequestVoteRequestProto.newBuilder().setServerRequest(ServerProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId, groupId)).setCandidateTerm(term);
        if (lastEntry != null) {
            b.setCandidateLastEntry(ServerProtoUtils.toTermIndexProto(lastEntry));
        }
        return b.build();
    }

    public static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, long term, int requestIndex, RaftProtos.InstallSnapshotResult result) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, groupId, result == RaftProtos.InstallSnapshotResult.SUCCESS);
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(term).setResult(result).setRequestIndex(requestIndex);
        return builder.build();
    }

    public static RaftProtos.InstallSnapshotRequestProto toInstallSnapshotRequestProto(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, String requestId, int requestIndex, long term, TermIndex lastTermIndex, List<RaftProtos.FileChunkProto> chunks, long totalSize, boolean done) {
        return RaftProtos.InstallSnapshotRequestProto.newBuilder().setServerRequest(ServerProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId, groupId)).setRequestId(requestId).setRequestIndex(requestIndex).setLeaderTerm(term).setTermIndex(ServerProtoUtils.toTermIndexProto(lastTermIndex)).addAllFileChunks(chunks).setTotalSize(totalSize).setDone(done).build();
    }

    public static RaftProtos.AppendEntriesReplyProto toAppendEntriesReplyProto(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, long term, long nextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult result, long callId) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, groupId, result == RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS).setCallId(callId);
        return RaftProtos.AppendEntriesReplyProto.newBuilder().setServerReply(rpcReply).setTerm(term).setNextIndex(nextIndex).setResult(result).build();
    }

    public static RaftProtos.AppendEntriesRequestProto toAppendEntriesRequestProto(RaftPeerId requestorId, RaftPeerId replyId, RaftGroupId groupId, long leaderTerm, List<RaftProtos.LogEntryProto> entries, long leaderCommit, boolean initializing, TermIndex previous, Collection<RaftProtos.CommitInfoProto> commitInfos, long callId) {
        RaftProtos.RaftRpcRequestProto.Builder rpcRequest = ServerProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId, groupId).setCallId(callId);
        RaftProtos.AppendEntriesRequestProto.Builder b = RaftProtos.AppendEntriesRequestProto.newBuilder().setServerRequest(rpcRequest).setLeaderTerm(leaderTerm).setLeaderCommit(leaderCommit).setInitializing(initializing);
        if (entries != null && !entries.isEmpty()) {
            b.addAllEntries(entries);
        }
        if (previous != null) {
            b.setPreviousLog(ServerProtoUtils.toTermIndexProto(previous));
        }
        ProtoUtils.addCommitInfos(commitInfos, i -> b.addCommitInfos(i));
        return b.build();
    }
}

