/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.Timestamp;

public class RoleInfo {
    private volatile RaftProtos.RaftPeerRole role;
    private final AtomicReference<Timestamp> transitionTime = new AtomicReference<Timestamp>(new Timestamp());

    RoleInfo() {
    }

    public void transitionRole(RaftProtos.RaftPeerRole newRole) {
        this.role = newRole;
        this.transitionTime.set(new Timestamp());
    }

    public long getRoleElapsedTimeMs() {
        return this.transitionTime.get().elapsedTimeMs();
    }

    public RaftProtos.RaftPeerRole getCurrentRole() {
        return this.role;
    }

    public boolean isFollower() {
        return this.role == RaftProtos.RaftPeerRole.FOLLOWER;
    }

    public boolean isCandidate() {
        return this.role == RaftProtos.RaftPeerRole.CANDIDATE;
    }

    public boolean isLeader() {
        return this.role == RaftProtos.RaftPeerRole.LEADER;
    }

    public String toString() {
        return "" + this.role;
    }
}

