/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RetryCache;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingRequests {
    public static final Logger LOG = LoggerFactory.getLogger(PendingRequests.class);
    private PendingRequest pendingSetConf;
    private final RaftServerImpl server;
    private final RequestMap pendingRequests;
    private PendingRequest last = null;
    private final DelayedReplies delayedReplies;

    PendingRequests(RaftServerImpl server) {
        this.server = server;
        this.pendingRequests = new RequestMap(server.getId());
        this.delayedReplies = new DelayedReplies(server.getId());
    }

    PendingRequest addPendingRequest(long index, RaftClientRequest request, TransactionContext entry) {
        Preconditions.assertTrue((boolean)request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE));
        if (this.last != null && !(this.last.getRequest() instanceof SetConfigurationRequest)) {
            Preconditions.assertTrue((index == this.last.getIndex() + 1L ? 1 : 0) != 0, () -> "index = " + index + " != last.getIndex() + 1, last=" + this.last);
        }
        return this.add(index, request, entry);
    }

    private PendingRequest add(long index, RaftClientRequest request, TransactionContext entry) {
        PendingRequest pending = new PendingRequest(index, request, entry);
        this.pendingRequests.put(index, pending);
        this.last = pending;
        return pending;
    }

    PendingRequest addConfRequest(SetConfigurationRequest request) {
        Preconditions.assertTrue((this.pendingSetConf == null ? 1 : 0) != 0);
        this.last = this.pendingSetConf = new PendingRequest(request);
        return this.pendingSetConf;
    }

    void replySetConfiguration() {
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setReply(new RaftClientReply(this.pendingSetConf.getRequest(), this.server.getCommitInfos()));
            this.pendingSetConf = null;
        }
    }

    void failSetConfiguration(RaftException e) {
        Preconditions.assertTrue((this.pendingSetConf != null ? 1 : 0) != 0);
        this.pendingSetConf.setException((Throwable)e);
        this.pendingSetConf = null;
    }

    TransactionContext getTransactionContext(long index) {
        PendingRequest pendingRequest = this.pendingRequests.get(index);
        return pendingRequest != null ? pendingRequest.getEntry() : null;
    }

    boolean replyPendingRequest(long index, RaftClientReply reply, RetryCache.CacheEntry cacheEntry) {
        PendingRequest pending = this.pendingRequests.remove(index);
        if (pending != null) {
            Preconditions.assertTrue((pending.getIndex() == index ? 1 : 0) != 0);
            RaftProtos.ReplicationLevel replication = pending.getRequest().getType().getWrite().getReplication();
            if (replication == RaftProtos.ReplicationLevel.ALL && this.delayedReplies.delay(pending, reply, cacheEntry)) {
                return false;
            }
            pending.setReply(reply);
        }
        return true;
    }

    void sendNotLeaderResponses() throws IOException {
        LOG.info("{} sends responses before shutting down PendingRequestsHandler", (Object)this.server.getId());
        NotLeaderException nle = this.server.generateNotLeaderException();
        this.server.getStateMachine().notifyNotLeader(this.pendingRequests.setNotLeaderException(nle));
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setNotLeaderException(nle);
        }
        this.delayedReplies.failReplies();
    }

    void checkDelayedReplies(long allAckedIndex) {
        this.delayedReplies.update(allAckedIndex);
    }

    private static class DelayedReplies {
        private final String name;
        private final PriorityQueue<PendingRequest> q = new PriorityQueue();
        private AtomicLong allAckedIndex = new AtomicLong();

        private DelayedReplies(Object name) {
            this.name = name + "-" + this.getClass().getSimpleName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean delay(PendingRequest request, RaftClientReply reply, RetryCache.CacheEntry cacheEntry) {
            boolean offered;
            if (request.getIndex() <= this.allAckedIndex.get()) {
                return false;
            }
            LOG.debug("{}: delay request {}", (Object)this.name, (Object)request);
            request.setDelayedReply(reply, cacheEntry);
            PriorityQueue<PendingRequest> priorityQueue = this.q;
            synchronized (priorityQueue) {
                offered = this.q.offer(request);
            }
            Preconditions.assertTrue((boolean)offered);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(long allAcked) {
            long old = this.allAckedIndex.getAndUpdate(n -> allAcked > n ? allAcked : n);
            if (allAcked <= old) {
                return;
            }
            LOG.debug("{}: update allAckedIndex {} -> {}", new Object[]{this.name, old, allAcked});
            while (true) {
                PendingRequest polled;
                PriorityQueue<PendingRequest> priorityQueue = this.q;
                synchronized (priorityQueue) {
                    PendingRequest peeked = this.q.peek();
                    if (peeked == null || peeked.getIndex() > allAcked) {
                        return;
                    }
                    polled = this.q.poll();
                    Preconditions.assertTrue((polled == peeked ? 1 : 0) != 0);
                }
                LOG.debug("{}: complete delay request {}", (Object)this.name, (Object)polled);
                polled.completeDelayedReply();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failReplies() {
            PriorityQueue<PendingRequest> priorityQueue = this.q;
            synchronized (priorityQueue) {
                while (!this.q.isEmpty()) {
                    this.q.poll().failDelayedReply();
                }
            }
        }
    }

    private static class RequestMap {
        private final Object name;
        private final ConcurrentMap<Long, PendingRequest> map = new ConcurrentHashMap<Long, PendingRequest>();

        RequestMap(Object name) {
            this.name = name;
        }

        void put(long index, PendingRequest p) {
            LOG.debug("{}: PendingRequests.put {} -> {}", new Object[]{this.name, index, p});
            PendingRequest previous = this.map.put(index, p);
            Preconditions.assertTrue((previous == null ? 1 : 0) != 0);
        }

        PendingRequest get(long index) {
            PendingRequest r = (PendingRequest)this.map.get(index);
            LOG.debug("{}: PendingRequests.get {} returns {}", new Object[]{this.name, index, r});
            return r;
        }

        PendingRequest remove(long index) {
            PendingRequest r = (PendingRequest)this.map.remove(index);
            LOG.debug("{}: PendingRequests.remove {} returns {}", new Object[]{this.name, index, r});
            return r;
        }

        Collection<TransactionContext> setNotLeaderException(NotLeaderException nle) {
            LOG.debug("{}: PendingRequests.setNotLeaderException", this.name);
            try {
                Collection collection = this.map.values().stream().map(p -> p.setNotLeaderException(nle)).collect(Collectors.toList());
                return collection;
            }
            finally {
                this.map.clear();
            }
        }
    }
}

