/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.Timestamp;

public class FollowerInfo {
    private final RaftPeer peer;
    private final AtomicReference<Timestamp> lastRpcResponseTime;
    private final AtomicReference<Timestamp> lastRpcSendTime;
    private long nextIndex;
    private final AtomicLong matchIndex;
    private final AtomicLong commitIndex = new AtomicLong(-1L);
    private volatile boolean attendVote;
    private final int rpcSlownessTimeoutMs;

    FollowerInfo(RaftPeer peer, Timestamp lastRpcTime, long nextIndex, boolean attendVote, int rpcSlownessTimeoutMs) {
        this.peer = peer;
        this.lastRpcResponseTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRpcSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.nextIndex = nextIndex;
        this.matchIndex = new AtomicLong(0L);
        this.attendVote = attendVote;
        this.rpcSlownessTimeoutMs = rpcSlownessTimeoutMs;
    }

    public void updateMatchIndex(long matchIndex) {
        this.matchIndex.set(matchIndex);
    }

    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    long getCommitIndex() {
        return this.commitIndex.get();
    }

    boolean updateCommitIndex(long newCommitIndex) {
        long old = this.commitIndex.getAndUpdate(oldCommitIndex -> newCommitIndex);
        Preconditions.assertTrue((newCommitIndex >= old ? 1 : 0) != 0, () -> "newCommitIndex = " + newCommitIndex + " < old = " + old);
        return old != newCommitIndex;
    }

    public synchronized long getNextIndex() {
        return this.nextIndex;
    }

    public synchronized void updateNextIndex(long i) {
        this.nextIndex = i;
    }

    public synchronized void decreaseNextIndex(long targetIndex) {
        if (this.nextIndex > 0L) {
            this.nextIndex = Math.min(this.nextIndex - 1L, targetIndex);
        }
    }

    public String toString() {
        return this.peer.getId() + "(next=" + this.nextIndex + ", match=" + this.matchIndex + ", attendVote=" + this.attendVote + ", lastRpcSendTime=" + this.lastRpcSendTime.get().elapsedTimeMs() + ", lastRpcResponseTime=" + this.lastRpcResponseTime.get().elapsedTimeMs() + ")";
    }

    void startAttendVote() {
        this.attendVote = true;
    }

    public boolean isAttendingVote() {
        return this.attendVote;
    }

    public RaftPeer getPeer() {
        return this.peer;
    }

    public void updateLastRpcResponseTime() {
        this.lastRpcResponseTime.set(new Timestamp());
    }

    public Timestamp getLastRpcResponseTime() {
        return this.lastRpcResponseTime.get();
    }

    public void updateLastRpcSendTime() {
        this.lastRpcSendTime.set(new Timestamp());
    }

    public Timestamp getLastRpcTime() {
        return Timestamp.latest((Timestamp)this.lastRpcResponseTime.get(), (Timestamp)this.lastRpcSendTime.get());
    }

    public boolean isSlow() {
        return this.lastRpcResponseTime.get().elapsedTimeMs() > (long)this.rpcSlownessTimeoutMs;
    }
}

