/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftServerConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerConfigKeys.class);
    public static final String PREFIX = "raft.server";
    public static final String STORAGE_DIR_KEY = "raft.server.storage.dir";
    public static final File STORAGE_DIR_DEFAULT = new File("/tmp/raft-server/");
    public static final String STAGING_CATCHUP_GAP_KEY = "raft.server.staging.catchup.gap";
    public static final int STAGING_CATCHUP_GAP_DEFAULT = 1000;
    public static final String LEADER_ELECTION_TIMEOUT_KEY = "raft.server.leader.election.timeout";
    public static final TimeDuration LEADER_ELECTION_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);

    public static Consumer<String> getDefaultLog() {
        return arg_0 -> ((Logger)LOG).info(arg_0);
    }

    public static File storageDir(RaftProperties properties) {
        return ConfUtils.getFile((arg_0, arg_1) -> ((RaftProperties)properties).getFile(arg_0, arg_1), (String)STORAGE_DIR_KEY, (File)STORAGE_DIR_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setStorageDir(RaftProperties properties, File storageDir) {
        ConfUtils.setFile((arg_0, arg_1) -> ((RaftProperties)properties).setFile(arg_0, arg_1), (String)STORAGE_DIR_KEY, (File)storageDir, (BiConsumer[])new BiConsumer[0]);
    }

    public static int stagingCatchupGap(RaftProperties properties) {
        return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)STAGING_CATCHUP_GAP_KEY, (int)1000, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
    }

    public static void setStagingCatchupGap(RaftProperties properties, int stagingCatchupGap) {
        ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)STAGING_CATCHUP_GAP_KEY, (int)stagingCatchupGap, (BiConsumer[])new BiConsumer[0]);
    }

    public static TimeDuration leaderElectionTimeout(RaftProperties properties) {
        return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(LEADER_ELECTION_TIMEOUT_DEFAULT.getUnit()), (String)LEADER_ELECTION_TIMEOUT_KEY, (TimeDuration)LEADER_ELECTION_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
    }

    public static void setLeaderElectionTimeout(RaftProperties properties, TimeDuration leaderElectionTimeout) {
        ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)LEADER_ELECTION_TIMEOUT_KEY, (TimeDuration)leaderElectionTimeout, (BiConsumer[])new BiConsumer[0]);
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftServerConfigKeys.class);
    }

    public static interface RetryCache {
        public static final String PREFIX = "raft.server.retrycache";
        public static final String CAPACITY_KEY = "raft.server.retrycache.capacity";
        public static final int CAPACITY_DEFAULT = 4096;
        public static final String EXPIRY_TIME_KEY = "raft.server.retrycache.expirytime";
        public static final TimeDuration EXPIRY_TIME_DEFAULT = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);

        public static int capacity(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)CAPACITY_KEY, (int)4096, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setCapacity(RaftProperties properties, int capacity) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)CAPACITY_KEY, (int)capacity, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration expiryTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(EXPIRY_TIME_DEFAULT.getUnit()), (String)EXPIRY_TIME_KEY, (TimeDuration)EXPIRY_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setExpiryTime(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)EXPIRY_TIME_KEY, (TimeDuration)expiryTime, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.server.rpc";
        public static final String TIMEOUT_MIN_KEY = "raft.server.rpc.timeout.min";
        public static final TimeDuration TIMEOUT_MIN_DEFAULT = TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String TIMEOUT_MAX_KEY = "raft.server.rpc.timeout.max";
        public static final TimeDuration TIMEOUT_MAX_DEFAULT = TimeDuration.valueOf((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String REQUEST_TIMEOUT_KEY = "raft.server.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String SLEEP_TIME_KEY = "raft.server.rpc.sleep.time";
        public static final TimeDuration SLEEP_TIME_DEFAULT = TimeDuration.valueOf((long)25L, (TimeUnit)TimeUnit.MILLISECONDS);
        public static final String SLOWNESS_TIMEOUT_KEY = "raft.server.rpcslowness.timeout";
        public static final TimeDuration SLOWNESS_TIMEOUT_DEFAULT = TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS);

        public static TimeDuration timeoutMin(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(TIMEOUT_MIN_DEFAULT.getUnit()), (String)TIMEOUT_MIN_KEY, (TimeDuration)TIMEOUT_MIN_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setTimeoutMin(RaftProperties properties, TimeDuration minDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)TIMEOUT_MIN_KEY, (TimeDuration)minDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration timeoutMax(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(TIMEOUT_MAX_DEFAULT.getUnit()), (String)TIMEOUT_MAX_KEY, (TimeDuration)TIMEOUT_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setTimeoutMax(RaftProperties properties, TimeDuration maxDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)TIMEOUT_MAX_KEY, (TimeDuration)maxDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)REQUEST_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)REQUEST_TIMEOUT_KEY, (TimeDuration)timeoutDuration, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration sleepTime(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(SLEEP_TIME_DEFAULT.getUnit()), (String)SLEEP_TIME_KEY, (TimeDuration)SLEEP_TIME_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSleepTime(RaftProperties properties, TimeDuration sleepTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)SLEEP_TIME_KEY, (TimeDuration)sleepTime, (BiConsumer[])new BiConsumer[0]);
        }

        public static TimeDuration slownessTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration((BiFunction)properties.getTimeDuration(SLOWNESS_TIMEOUT_DEFAULT.getUnit()), (String)SLOWNESS_TIMEOUT_KEY, (TimeDuration)SLOWNESS_TIMEOUT_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSlownessTimeout(RaftProperties properties, TimeDuration expiryTime) {
            ConfUtils.setTimeDuration((arg_0, arg_1) -> ((RaftProperties)properties).setTimeDuration(arg_0, arg_1), (String)SLOWNESS_TIMEOUT_KEY, (TimeDuration)expiryTime, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Snapshot {
        public static final String PREFIX = "raft.server.snapshot";
        public static final String AUTO_TRIGGER_ENABLED_KEY = "raft.server.snapshot.auto.trigger.enabled";
        public static final boolean AUTO_TRIGGER_ENABLED_DEFAULT = false;
        public static final String AUTO_TRIGGER_THRESHOLD_KEY = "raft.server.snapshot.auto.trigger.threshold";
        public static final long AUTO_TRIGGER_THRESHOLD_DEFAULT = 400000L;

        public static boolean autoTriggerEnabled(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)AUTO_TRIGGER_ENABLED_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setAutoTriggerEnabled(RaftProperties properties, boolean autoTriggerThreshold) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)AUTO_TRIGGER_ENABLED_KEY, (boolean)autoTriggerThreshold, (BiConsumer[])new BiConsumer[0]);
        }

        public static long autoTriggerThreshold(RaftProperties properties) {
            return ConfUtils.getLong((arg_0, arg_1) -> ((RaftProperties)properties).getLong(arg_0, arg_1), (String)AUTO_TRIGGER_THRESHOLD_KEY, (long)400000L, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((long)0L)});
        }

        public static void setAutoTriggerThreshold(RaftProperties properties, long autoTriggerThreshold) {
            ConfUtils.setLong((arg_0, arg_1) -> ((RaftProperties)properties).setLong(arg_0, arg_1), (String)AUTO_TRIGGER_THRESHOLD_KEY, (long)autoTriggerThreshold, (BiConsumer[])new BiConsumer[0]);
        }
    }

    public static interface Log {
        public static final String PREFIX = "raft.server.log";
        public static final String USE_MEMORY_KEY = "raft.server.log.use.memory";
        public static final boolean USE_MEMORY_DEFAULT = false;
        public static final String SEGMENT_SIZE_MAX_KEY = "raft.server.log.segment.size.max";
        public static final SizeInBytes SEGMENT_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"8MB");
        public static final String SEGMENT_CACHE_MAX_NUM_KEY = "raft.server.log.segment.cache.num.max";
        public static final int SEGMENT_CACHE_MAX_NUM_DEFAULT = 6;
        public static final String PREALLOCATED_SIZE_KEY = "raft.server.log.preallocated.size";
        public static final SizeInBytes PREALLOCATED_SIZE_DEFAULT = SizeInBytes.valueOf((String)"4MB");
        public static final String WRITE_BUFFER_SIZE_KEY = "raft.server.log.write.buffer.size";
        public static final SizeInBytes WRITE_BUFFER_SIZE_DEFAULT = SizeInBytes.valueOf((String)"64KB");
        public static final String FORCE_SYNC_NUM_KEY = "raft.server.log.force.sync.num";
        public static final int FORCE_SYNC_NUM_DEFAULT = 128;

        public static boolean useMemory(RaftProperties properties) {
            return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)USE_MEMORY_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setUseMemory(RaftProperties properties, boolean useMemory) {
            ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)USE_MEMORY_KEY, (boolean)useMemory, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes segmentSizeMax(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)SEGMENT_SIZE_MAX_KEY, (SizeInBytes)SEGMENT_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setSegmentSizeMax(RaftProperties properties, SizeInBytes segmentSizeMax) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)SEGMENT_SIZE_MAX_KEY, (SizeInBytes)segmentSizeMax, (BiConsumer[])new BiConsumer[0]);
        }

        public static int maxCachedSegmentNum(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)SEGMENT_CACHE_MAX_NUM_KEY, (int)6, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setMaxCachedSegmentNum(RaftProperties properties, int maxCachedSegmentNum) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)SEGMENT_CACHE_MAX_NUM_KEY, (int)maxCachedSegmentNum, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes preallocatedSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)PREALLOCATED_SIZE_KEY, (SizeInBytes)PREALLOCATED_SIZE_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setPreallocatedSize(RaftProperties properties, SizeInBytes preallocatedSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)PREALLOCATED_SIZE_KEY, (SizeInBytes)preallocatedSize, (BiConsumer[])new BiConsumer[0]);
        }

        public static SizeInBytes writeBufferSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)WRITE_BUFFER_SIZE_KEY, (SizeInBytes)WRITE_BUFFER_SIZE_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
        }

        public static void setWriteBufferSize(RaftProperties properties, SizeInBytes writeBufferSize) {
            ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)WRITE_BUFFER_SIZE_KEY, (SizeInBytes)writeBufferSize, (BiConsumer[])new BiConsumer[0]);
        }

        public static int forceSyncNum(RaftProperties properties) {
            return ConfUtils.getInt((arg_0, arg_1) -> ((RaftProperties)properties).getInt(arg_0, arg_1), (String)FORCE_SYNC_NUM_KEY, (int)128, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[]{ConfUtils.requireMin((int)0)});
        }

        public static void setForceSyncNum(RaftProperties properties, int forceSyncNum) {
            ConfUtils.setInt((arg_0, arg_1) -> ((RaftProperties)properties).setInt(arg_0, arg_1), (String)FORCE_SYNC_NUM_KEY, (int)forceSyncNum, (BiConsumer[])new BiConsumer[0]);
        }

        public static interface Appender {
            public static final String PREFIX = "raft.server.log.appender";
            public static final String BUFFER_CAPACITY_KEY = "raft.server.log.appender.buffer.capacity";
            public static final SizeInBytes BUFFER_CAPACITY_DEFAULT = SizeInBytes.valueOf((String)"4MB");
            public static final String BATCH_ENABLED_KEY = "raft.server.log.appender.batch.enabled";
            public static final boolean BATCH_ENABLED_DEFAULT = false;
            public static final String SNAPSHOT_CHUNK_SIZE_MAX_KEY = "raft.server.log.appender.snapshot.chunk.size.max";
            public static final SizeInBytes SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT = SizeInBytes.valueOf((String)"16MB");

            public static SizeInBytes bufferCapacity(RaftProperties properties) {
                return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)BUFFER_CAPACITY_KEY, (SizeInBytes)BUFFER_CAPACITY_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setBufferCapacity(RaftProperties properties, SizeInBytes bufferCapacity) {
                ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)BUFFER_CAPACITY_KEY, (SizeInBytes)bufferCapacity, (BiConsumer[])new BiConsumer[0]);
            }

            public static boolean batchEnabled(RaftProperties properties) {
                return ConfUtils.getBoolean((arg_0, arg_1) -> ((RaftProperties)properties).getBoolean(arg_0, arg_1), (String)BATCH_ENABLED_KEY, (boolean)false, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setBatchEnabled(RaftProperties properties, boolean batchEnabled) {
                ConfUtils.setBoolean((arg_0, arg_1) -> ((RaftProperties)properties).setBoolean(arg_0, arg_1), (String)BATCH_ENABLED_KEY, (boolean)batchEnabled, (BiConsumer[])new BiConsumer[0]);
            }

            public static SizeInBytes snapshotChunkSizeMax(RaftProperties properties) {
                return ConfUtils.getSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).getSizeInBytes(arg_0, arg_1), (String)SNAPSHOT_CHUNK_SIZE_MAX_KEY, (SizeInBytes)SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT, RaftServerConfigKeys.getDefaultLog(), (BiConsumer[])new BiConsumer[0]);
            }

            public static void setSnapshotChunkSizeMax(RaftProperties properties, SizeInBytes maxChunkSize) {
                ConfUtils.setSizeInBytes((arg_0, arg_1) -> ((RaftProperties)properties).set(arg_0, arg_1), (String)SNAPSHOT_CHUNK_SIZE_MAX_KEY, (SizeInBytes)maxChunkSize, (BiConsumer[])new BiConsumer[0]);
            }
        }
    }
}

