/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.AdminProtocol;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientProtocol;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.impl.ServerFactory;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.LifeCycle;

public interface RaftServer
extends Closeable,
RpcType.Get,
RaftServerProtocol,
RaftServerAsynchronousProtocol,
RaftClientProtocol,
RaftClientAsynchronousProtocol,
AdminProtocol,
AdminAsynchronousProtocol {
    public RaftPeerId getId();

    public Iterable<RaftGroupId> getGroupIds() throws IOException;

    public RaftProperties getProperties();

    public ServerFactory getFactory();

    public void start() throws IOException;

    public LifeCycle.State getLifeCycleState();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private RaftPeerId serverId;
        private StateMachine stateMachine;
        private RaftGroup group = null;
        private RaftProperties properties;
        private Parameters parameters;

        public RaftServer build() throws IOException {
            return ServerImplUtils.newRaftServer(this.serverId, this.group, Objects.requireNonNull(this.stateMachine, "The 'stateMachine' is not initialized."), Objects.requireNonNull(this.properties, "The 'properties' field is not initialized."), this.parameters);
        }

        public Builder setServerId(RaftPeerId serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder setStateMachine(StateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        public Builder setGroup(RaftGroup group) {
            this.group = group;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }
    }
}

